/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.dcache.srm.util.events.ExistingKeyValueMapAdded;
import org.dcache.srm.util.events.KeyMapNonLastValueRemoved;
import org.dcache.srm.util.events.KeyValueMapRemoved;
import org.dcache.srm.util.events.NewKeyValueMapAdded;
import org.dcache.srm.util.events.OneToManyMapChangeListener;
import org.dcache.srm.util.events.OneToManyMapChangeSupport;

public class OneToManyMap
extends HashMap {
    private OneToManyMapChangeSupport changeSupport = new OneToManyMapChangeSupport(this);
    private static final long serialVersionUID = 7475338557089457074L;

    @Override
    public Object put(Object key, Object value) {
        MappedSet mappedSet;
        if (this.containsKey(key)) {
            mappedSet = (MappedSet)super.get(key);
            mappedSet.add(value);
            this.changeSupport.firePropertyChange(new ExistingKeyValueMapAdded(this, key, value));
        } else {
            mappedSet = new MappedSet();
            mappedSet.add(value);
            this.changeSupport.firePropertyChange(new NewKeyValueMapAdded(this, key, value));
        }
        return super.put(key, mappedSet);
    }

    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (o == null) {
            return null;
        }
        return ((MappedSet)o).iterator().next();
    }

    public Set getValues(Object key) {
        Object o = super.get(key);
        if (o == null) {
            return null;
        }
        return (MappedSet)o;
    }

    @Override
    public boolean containsValue(Object value) {
        for (MappedSet ms : super.values()) {
            if (!ms.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object remove(Object key) {
        Object o = super.get(key);
        if (o == null) {
            return null;
        }
        MappedSet ms = (MappedSet)o;
        Object value = ms.iterator().next();
        ms.remove(value);
        if (ms.size() == 0) {
            super.remove(key);
            this.changeSupport.firePropertyChange(new KeyValueMapRemoved(this, key, value));
        } else {
            this.changeSupport.firePropertyChange(new KeyMapNonLastValueRemoved(this, key, value));
        }
        return value;
    }

    public Object remove(Object key, Object value) {
        Object o = super.get(key);
        if (o == null) {
            return null;
        }
        MappedSet ms = (MappedSet)o;
        if (!ms.contains(value)) {
            return null;
        }
        ms.remove(value);
        if (ms.size() == 0) {
            super.remove(key);
            this.changeSupport.firePropertyChange(new KeyValueMapRemoved(this, key, value));
        } else {
            this.changeSupport.firePropertyChange(new KeyMapNonLastValueRemoved(this, key, value));
        }
        return value;
    }

    public void addChangeListener(OneToManyMapChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(OneToManyMapChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public static class MappedSet
    extends HashSet {
        private static final long serialVersionUID = -5084522542876587442L;
    }
}

