/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.security;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class DelegationTestMiddleServer {
    private String x509ServiceCert;
    private String x509ServiceKey;
    private String x509TrastedCACerts;
    private static GlobusCredential service_cred;
    private static TrustedCertificates trusted_certs;

    public DelegationTestMiddleServer(String x509ServiceCert, String x509ServiceKey, String x509TrastedCACerts, int port) throws IOException {
        this.x509ServiceCert = x509ServiceCert;
        this.x509ServiceKey = x509ServiceKey;
        this.x509TrastedCACerts = x509TrastedCACerts;
        ServerSocket ss = new ServerSocket(port);
        while (true) {
            final Socket s = ss.accept();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DelegationTestMiddleServer.this.handle(s);
                }
            }).start();
        }
    }

    public static void delegateCredential(InetAddress inetAddress, int port, GSSCredential credential, boolean fulldelegation) throws Exception {
        Socket s = null;
        try {
            GSSManager manager = ExtendedGSSManager.getInstance();
            HostAuthorization gssAuth = HostAuthorization.getInstance();
            GSSName targetName = gssAuth.getExpectedName(null, inetAddress.getCanonicalHostName());
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(targetName, GSSConstants.MECH_OID, credential, 0);
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            context.requestCredDeleg(true);
            if (fulldelegation) {
                context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_FULL);
            } else {
                context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_LIMITED);
            }
            s = new Socket(inetAddress, port);
            GSIGssSocket gsiSocket = new GSIGssSocket(s, (GSSContext)context);
            gsiSocket.setUseClientMode(true);
            gsiSocket.setAuthorization((Authorization)gssAuth);
            gsiSocket.setWrapMode(1);
            gsiSocket.startHandshake();
        }
        catch (Exception e) {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Socket s) {
        try {
            GSSContext context = this.getServiceContext();
            GSIGssSocket gsis = new GSIGssSocket(s, context);
            gsis.setAuthorization(new Authorization(){

                public void authorize(GSSContext context, String host) throws AuthorizationException {
                    DelegationTestMiddleServer.this.say("authorized");
                }
            });
            gsis.setUseClientMode(false);
            gsis.setWrapMode(1);
            DataInputStream inStream = new DataInputStream(gsis.getInputStream());
            String str = inStream.readUTF();
            inStream.close();
            this.say("read utf: " + str);
            InetAddress finaldesthost = InetAddress.getByName(str.substring(0, str.indexOf(32)));
            int finaldestport = Integer.parseInt(str.substring(str.indexOf(32) + 1));
            GSSCredential cred = gsis.getContext().getDelegCred();
            if (cred != null) {
                this.say("received deleg cred " + cred.getName());
                this.say("delegatig to host =" + finaldesthost + " port=" + finaldestport);
                DelegationTestMiddleServer.delegateCredential(finaldesthost, finaldestport, cred, false);
            }
        }
        catch (Exception e) {
            this.esay(e);
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
    }

    public void say(String s) {
        System.out.println(s);
    }

    public void esay(String s) {
        System.err.println(s);
    }

    public void esay(Throwable t) {
        t.printStackTrace();
    }

    public static GSSCredential getServiceCredential(String x509ServiceCert, String x509ServiceKey, int usage) throws GSSException {
        try {
            if (service_cred != null) {
                service_cred.verify();
            }
        }
        catch (GlobusCredentialException gce) {
            service_cred = null;
        }
        if (service_cred == null) {
            try {
                service_cred = new GlobusCredential(x509ServiceCert, x509ServiceKey);
            }
            catch (GlobusCredentialException gce) {
                throw new GSSException(13, 0, "could not load host globus credentials " + gce.toString());
            }
        }
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(service_cred, usage);
        return cred;
    }

    public static GSSContext getServiceContext(String x509ServiceCert, String x509ServiceKey, String x509TrastedCACerts) throws GSSException {
        GSSCredential cred = DelegationTestMiddleServer.getServiceCredential(x509ServiceCert, x509ServiceKey, 2);
        if (trusted_certs == null) {
            trusted_certs = TrustedCertificates.load((String)x509TrastedCACerts);
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(cred);
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trusted_certs);
        return context;
    }

    private GSSContext getServiceContext() throws GSSException {
        try {
            return DelegationTestMiddleServer.getServiceContext(this.x509ServiceCert, this.x509ServiceKey, this.x509TrastedCACerts);
        }
        catch (GSSException gsse) {
            this.esay(gsse);
            throw gsse;
        }
    }

    public static final void main(String[] args) throws IOException {
        String x509ServiceCert = args[0];
        String x509ServiceKey = args[1];
        String x509TrastedCACerts = args[2];
        int port = Integer.parseInt(args[3]);
        new DelegationTestMiddleServer(x509ServiceCert, x509ServiceKey, x509TrastedCACerts, port);
    }
}

