/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dcache.srm.v2_2.TRetentionPolicy;

public enum RetentionPolicy {
    REPLICA(TRetentionPolicy.REPLICA),
    OUTPUT(TRetentionPolicy.OUTPUT),
    CUSTODIAL(TRetentionPolicy.CUSTODIAL);

    private final TRetentionPolicy _policy;
    private static final Map<TRetentionPolicy, RetentionPolicy> MAP;
    private static final String ERROR_MESSAGE;

    private RetentionPolicy(TRetentionPolicy policy) {
        this._policy = policy;
    }

    public TRetentionPolicy toTRetentionPolicy() {
        return this._policy;
    }

    public static RetentionPolicy fromTRetentionPolicy(TRetentionPolicy policy) {
        if (policy == null) {
            return null;
        }
        return MAP.get(policy);
    }

    public static RetentionPolicy fromString(String txt) throws IllegalArgumentException {
        try {
            TRetentionPolicy policy = TRetentionPolicy.fromString(txt);
            return RetentionPolicy.fromTRetentionPolicy(policy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown RetentionPolicy: \"%s\".");
        sb.append(" Supported values :");
        HashMap<TRetentionPolicy, RetentionPolicy> m = new HashMap<TRetentionPolicy, RetentionPolicy>();
        for (RetentionPolicy value : RetentionPolicy.values()) {
            m.put(value._policy, value);
            sb.append(" \"").append(value._policy).append("\"");
        }
        MAP = Collections.unmodifiableMap(m);
        ERROR_MESSAGE = sb.toString();
    }
}

