/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.dcache.srm.request.RequestCredentialStorage;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class RequestCredential {
    private static final Map weakRequestCredentialStorage = Collections.synchronizedMap(new WeakHashMap());
    private Long id;
    private long creationtime;
    private String credentialName;
    private String role;
    private boolean saved;
    private GSSCredential delegatedCredential;
    private long delegatedCredentialExpiration;
    private RequestCredentialStorage storage;
    private int credential_users;
    private static final Set requestCredentailStorages = new HashSet();
    private static final long serialVersionUID = 4986528613717664419L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerRequestCredentialStorage(RequestCredentialStorage requestCredentialStorage) {
        Set set = requestCredentailStorages;
        synchronized (set) {
            requestCredentailStorages.add(requestCredentialStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestCredential getRequestCredential(Long requestCredentialId) {
        RequestCredentialStorage[] requestCreatorStoragesArray;
        Object o;
        Map map = weakRequestCredentialStorage;
        synchronized (map) {
            WeakReference ref;
            Object o1;
            o = weakRequestCredentialStorage.get(requestCredentialId);
            if (o != null && (o1 = (ref = (WeakReference)o).get()) != null) {
                return (RequestCredential)o1;
            }
        }
        o = requestCredentailStorages;
        synchronized (o) {
            requestCreatorStoragesArray = requestCredentailStorages.toArray(new RequestCredentialStorage[0]);
        }
        for (int i = 0; i < requestCreatorStoragesArray.length; ++i) {
            RequestCredential requestCredential = requestCreatorStoragesArray[i].getRequestCredential(requestCredentialId);
            if (requestCredential == null) continue;
            Map map2 = weakRequestCredentialStorage;
            synchronized (map2) {
                weakRequestCredentialStorage.put(requestCredential.id, new WeakReference<RequestCredential>(requestCredential));
            }
            return requestCredential;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestCredential getRequestCredential(String credentialName, String role) {
        RequestCredentialStorage[] requestCreatorStoragesArray;
        Map map = weakRequestCredentialStorage;
        synchronized (map) {
            for (WeakReference ref : weakRequestCredentialStorage.values()) {
                Object o1 = ref.get();
                if (o1 == null) continue;
                RequestCredential cred = (RequestCredential)o1;
                String credName = cred.getCredentialName();
                String credRole = cred.getRole();
                if (!credName.equals(credentialName) || (role != null || credRole != null) && (role == null || !role.equals(credRole))) continue;
                return cred;
            }
        }
        Set i = requestCredentailStorages;
        synchronized (i) {
            requestCreatorStoragesArray = requestCredentailStorages.toArray(new RequestCredentialStorage[0]);
        }
        for (int i2 = 0; i2 < requestCreatorStoragesArray.length; ++i2) {
            RequestCredential requestCredential = requestCreatorStoragesArray[i2].getRequestCredential(credentialName, role);
            if (requestCredential == null) continue;
            Map map2 = weakRequestCredentialStorage;
            synchronized (map2) {
                weakRequestCredentialStorage.put(requestCredential.id, new WeakReference<RequestCredential>(requestCredential));
            }
            return requestCredential;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestCredential(String credentialName, String role, GSSCredential delegatedCredential, RequestCredentialStorage storage) throws SQLException, GSSException {
        this.id = System.currentTimeMillis();
        this.creationtime = System.currentTimeMillis();
        this.credentialName = credentialName;
        this.role = role;
        if (delegatedCredential != null) {
            this.delegatedCredential = delegatedCredential;
            this.delegatedCredentialExpiration = this.creationtime + (long)delegatedCredential.getRemainingLifetime() * 1000L;
        }
        this.storage = storage;
        Map map = weakRequestCredentialStorage;
        synchronized (map) {
            weakRequestCredentialStorage.put(this.id, new WeakReference<RequestCredential>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestCredential(Long id, long creationtime, String credentialName, String role, GSSCredential delegatedCredential, long delegatedCredentialExpiration, RequestCredentialStorage storage) throws SQLException {
        this.id = id;
        this.creationtime = creationtime;
        this.credentialName = credentialName;
        this.role = role;
        if (delegatedCredential != null) {
            this.delegatedCredential = delegatedCredential;
            this.delegatedCredentialExpiration = delegatedCredentialExpiration;
        }
        this.storage = storage;
        Map map = weakRequestCredentialStorage;
        synchronized (map) {
            weakRequestCredentialStorage.put(this.id, new WeakReference<RequestCredential>(this));
        }
    }

    public GSSCredential getDelegatedCredential() {
        return this.delegatedCredential;
    }

    public void keepBestDelegatedCredential(GSSCredential delegatedCredential) throws GSSException {
        if (delegatedCredential == null) {
            return;
        }
        long newCredentialExpiration = System.currentTimeMillis() + (long)delegatedCredential.getRemainingLifetime() * 1000L;
        if (this.delegatedCredential == null || newCredentialExpiration > this.delegatedCredentialExpiration) {
            this.delegatedCredential = delegatedCredential;
            this.delegatedCredentialExpiration = newCredentialExpiration;
            this.saved = false;
            return;
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public String toString() {
        return "RequestCredential[" + this.credentialName + "," + (this.delegatedCredential == null ? "nondelegated" : "delegated, remaining lifetime : " + this.getDelegatedCredentialRemainingLifetime() + " millis") + "  ]";
    }

    public void decreaseCredential_users() {
        --this.credential_users;
        if (this.credential_users == 0) {
            this.delegatedCredential = null;
        }
        this.storage.saveRequestCredential(this);
    }

    public int getCredential_users() {
        return this.credential_users;
    }

    public void setCredential_users(int credential_users) {
        this.credential_users = credential_users;
    }

    public void saveCredential() {
        if (this.saved) {
            return;
        }
        this.storage.saveRequestCredential(this);
        this.saved = true;
    }

    public String getRole() {
        return this.role;
    }

    public long getDelegatedCredentialExpiration() {
        return this.delegatedCredentialExpiration;
    }

    public long getCreationtime() {
        return this.creationtime;
    }

    public long getDelegatedCredentialRemainingLifetime() {
        long lifetime = this.delegatedCredentialExpiration - System.currentTimeMillis();
        return lifetime < 0L ? 0L : lifetime;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }
}

