/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dcache.srm.v2_2.TOverwriteMode;

public enum OverwriteMode {
    NEVER(TOverwriteMode.NEVER),
    ALWAYS(TOverwriteMode.ALWAYS),
    WHEN_FILES_ARE_DIFFERENT(TOverwriteMode.WHEN_FILES_ARE_DIFFERENT);

    private final TOverwriteMode _mode;
    private static final Map<TOverwriteMode, OverwriteMode> MAP;
    private static final String ERROR_MESSAGE;

    private OverwriteMode(TOverwriteMode mode) {
        this._mode = mode;
    }

    public TOverwriteMode toTOverwriteMode() {
        return this._mode;
    }

    public static OverwriteMode fromTOverwriteMode(TOverwriteMode mode) {
        if (mode == null) {
            return null;
        }
        return MAP.get(mode);
    }

    public static OverwriteMode fromString(String txt) throws IllegalArgumentException {
        try {
            TOverwriteMode mode = TOverwriteMode.fromString(txt);
            return OverwriteMode.fromTOverwriteMode(mode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown OverwriteMode: \"%s\".");
        sb.append(" Supported values :");
        HashMap<TOverwriteMode, OverwriteMode> m = new HashMap<TOverwriteMode, OverwriteMode>();
        for (OverwriteMode value : OverwriteMode.values()) {
            m.put(value._mode, value);
            sb.append(" \"").append(value._mode).append("\"");
        }
        MAP = Collections.unmodifiableMap(m);
        ERROR_MESSAGE = sb.toString();
    }
}

