/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dcache.srm.v2_2.TFileStorageType;

public enum FileStorageType {
    VOLATILE(TFileStorageType.VOLATILE),
    DURABLE(TFileStorageType.DURABLE),
    PERMANENT(TFileStorageType.PERMANENT);

    private final TFileStorageType _type;
    private static final Map<TFileStorageType, FileStorageType> MAP;
    private static final String ERROR_MESSAGE;

    private FileStorageType(TFileStorageType type) {
        this._type = type;
    }

    public TFileStorageType toTFileStorageType() {
        return this._type;
    }

    public static FileStorageType fromTFileStorageType(TFileStorageType type) {
        if (type == null) {
            return null;
        }
        return MAP.get(type);
    }

    public static FileStorageType fromString(String txt) throws IllegalArgumentException {
        try {
            TFileStorageType type = TFileStorageType.fromString(txt);
            return FileStorageType.fromTFileStorageType(type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown FileStorageType: \"%s\".");
        sb.append(" Supported values :");
        HashMap<TFileStorageType, FileStorageType> m = new HashMap<TFileStorageType, FileStorageType>();
        for (FileStorageType value : FileStorageType.values()) {
            m.put(value._type, value);
            sb.append(" \"").append(value._type).append("\"");
        }
        MAP = Collections.unmodifiableMap(m);
        ERROR_MESSAGE = sb.toString();
    }
}

