/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

import diskCacheV111.srm.ISRM;
import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRMException;
import org.dcache.srm.client.SRMClientV1;
import org.dcache.srm.client.Transport;
import org.dcache.srm.client.TurlGetterPutter;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.SrmUrl;

public abstract class TurlGetterPutterV1
extends TurlGetterPutter {
    private static final Logger logger = Logger.getLogger(TurlGetterPutterV1.class);
    protected ISRM remoteSRM;
    private final Object sync = new Object();
    protected RequestStatus rs;
    private final HashSet<Integer> fileIDs = new HashSet();
    private HashMap<Integer, RequestFileStatus> fileIDsMap = new HashMap();
    protected String[] SURLs;
    protected int requestID;
    protected int number_of_file_reqs;
    protected boolean createdMap;
    private long retry_timout;
    private int retry_num;
    private final Transport transport;

    public TurlGetterPutterV1(AbstractStorageElement storage, RequestCredential credential, String[] SURLs, String[] protocols, long retry_timeout, int retry_num, Transport transport) {
        super(storage, credential, protocols);
        this.SURLs = SURLs;
        this.number_of_file_reqs = SURLs.length;
        this.retry_num = retry_num;
        this.retry_timout = retry_timeout;
        logger.debug((Object)("TurlGetterPutter, number_of_file_reqs = " + this.number_of_file_reqs));
        this.transport = transport;
    }

    @Override
    public void getInitialRequest() throws SRMException {
        if (this.number_of_file_reqs == 0) {
            logger.debug((Object)"number_of_file_reqs is 0, nothing to do");
            return;
        }
        try {
            this.remoteSRM = new SRMClientV1(new SrmUrl(this.SURLs[0]), this.credential.getDelegatedCredential(), this.retry_timout, this.retry_num, true, true, this.transport);
        }
        catch (Exception e) {
            throw new SRMException("failed to connect to " + this.SURLs[0], e);
        }
        logger.debug((Object)"run() : calling getInitialRequestStatus()");
        try {
            this.rs = this.getInitialRequestStatus();
        }
        catch (Exception e) {
            throw new SRMException("failed to get initial request status", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.number_of_file_reqs == 0) {
            logger.debug((Object)"number_of_file_reqs is 0, nothing to do");
            return;
        }
        if (this.rs.fileStatuses == null || this.rs.fileStatuses.length == 0) {
            String err = "run() : fileStatuses  are null or of zero length";
            this.notifyOfFailure(err);
            return;
        }
        this.requestID = this.rs.requestId;
        RequestFileStatus[] frs = this.rs.fileStatuses;
        if (frs.length != this.number_of_file_reqs) {
            this.notifyOfFailure("run(): wrong number of RequestFileStatuses " + frs.length + " should be " + this.number_of_file_reqs);
            return;
        }
        HashSet<Integer> hashSet = this.fileIDs;
        synchronized (hashSet) {
            for (int i = 0; i < this.number_of_file_reqs; ++i) {
                Integer fileId = frs[i].fileId;
                this.fileIDs.add(fileId);
                this.fileIDsMap.put(fileId, frs[i]);
            }
            this.createdMap = true;
        }
        logger.debug((Object)"getFromRemoteSRM() : received requestStatus, waiting");
        try {
            this.waitForReadyStatuses();
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            this.notifyOfFailure(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReadyStatuses() throws Exception {
        while (!this.fileIDs.isEmpty()) {
            if (this.isStopped()) {
                logger.debug((Object)("TurlGetterPutter is done, still have " + this.fileIDs.size() + " file ids"));
                for (Integer nextID : this.fileIDs) {
                    try {
                        logger.debug((Object)("calling setFileStatus(" + this.requestID + "," + nextID + ",\"Done\") on remote server"));
                        this.setFileStatus(this.requestID, nextID, "Done");
                    }
                    catch (Exception e) {
                        logger.error((Object)"error setting file status to done", (Throwable)e);
                    }
                    try {
                        RequestFileStatus frs = TurlGetterPutterV1.getFileRequest(this.rs, nextID);
                        this.notifyOfFailure(frs.SURL, "stopped by user request", Integer.toString(this.rs.requestId), nextID.toString());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.toString());
                    }
                }
                break;
            }
            boolean totalFailure = false;
            String totalFailureError = null;
            HashSet<Integer> removeIDs = new HashSet<Integer>();
            HashMap<Integer, Boolean> removedIDsToResutls = new HashMap<Integer, Boolean>();
            HashMap<Integer, String> removedIDsToSURL = new HashMap<Integer, String>();
            HashMap<Integer, String> removedIDsToTURL = new HashMap<Integer, String>();
            HashMap<Integer, Long> removedIDsToSizes = new HashMap<Integer, Long>();
            HashMap<Integer, String> removeIDsToErrorMessages = new HashMap<Integer, String>();
            HashSet<Integer> hashSet = this.fileIDs;
            synchronized (hashSet) {
                for (Integer nextID : this.fileIDs) {
                    RequestFileStatus frs;
                    try {
                        frs = TurlGetterPutterV1.getFileRequest(this.rs, nextID);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.toString());
                        totalFailure = true;
                        totalFailureError = " run() getFileRequest  failed with ioe=" + e;
                        break;
                    }
                    if (frs == null) {
                        totalFailure = true;
                        totalFailureError = "request status does not haveRequestFileStatus fileID = " + nextID;
                        break;
                    }
                    if (frs.state == null) {
                        totalFailure = true;
                        totalFailureError = "request status does not have state (state is null)RequestFileStatus fileID = " + nextID;
                        break;
                    }
                    if (frs.state.equals("Pending")) continue;
                    logger.debug((Object)("waitForReadyStatuses() received the RequestFileStatus with Status=" + frs.state + " for SURL=" + frs.SURL));
                    removeIDs.add(nextID);
                    removedIDsToSURL.put(nextID, frs.SURL);
                    if (frs.state.equals("Failed")) {
                        removedIDsToResutls.put(nextID, Boolean.FALSE);
                        removeIDsToErrorMessages.put(nextID, "remote srm set state to Failed");
                        continue;
                    }
                    if (frs.state.equals("Ready") || frs.state.equals("Running")) {
                        if (frs.TURL == null) {
                            removeIDs.add(nextID);
                            removedIDsToResutls.put(nextID, Boolean.FALSE);
                            removeIDsToErrorMessages.put(nextID, "  TURL nof found but fileStatus state ==" + frs.state);
                            continue;
                        }
                        logger.debug((Object)("waitForReadyStatuses(): FileRequestStatus is Ready received TURL=" + frs.TURL));
                        removeIDs.add(nextID);
                        removedIDsToResutls.put(nextID, Boolean.TRUE);
                        removedIDsToTURL.put(nextID, frs.TURL);
                        if (frs.size <= 0L) continue;
                        removedIDsToSizes.put(nextID, frs.size);
                        continue;
                    }
                    if (frs.state.equals("Done")) {
                        removedIDsToResutls.put(nextID, Boolean.FALSE);
                        removeIDsToErrorMessages.put(nextID, "remote srm set state to Done, when we were waiting for Ready");
                        continue;
                    }
                    removedIDsToResutls.put(nextID, Boolean.FALSE);
                    removeIDsToErrorMessages.put(nextID, "remote srm set state is unknown :" + frs.state + ", when we were waiting for Ready");
                }
                this.fileIDs.removeAll(removeIDs);
            }
            if (totalFailure) {
                logger.error((Object)(" breaking the waiting loop with a failure:" + totalFailureError));
                this.notifyOfFailure(totalFailureError);
                return;
            }
            for (Integer nextRemoveId : removeIDs) {
                String surl = (String)removedIDsToSURL.get(nextRemoveId);
                String turl = (String)removedIDsToTURL.get(nextRemoveId);
                Long size = (Long)removedIDsToSizes.get(nextRemoveId);
                Boolean success = (Boolean)removedIDsToResutls.get(nextRemoveId);
                if (success.booleanValue()) {
                    this.notifyOfTURL(surl, turl, Integer.toString(this.rs.requestId), nextRemoveId.toString(), size);
                    continue;
                }
                String errormsg = (String)removeIDsToErrorMessages.get(nextRemoveId);
                this.notifyOfFailure(surl, errormsg, Integer.toString(this.rs.requestId), nextRemoveId.toString());
            }
            removedIDsToSURL = null;
            removedIDsToTURL = null;
            removedIDsToSizes = null;
            removedIDsToResutls = null;
            removeIDsToErrorMessages = null;
            removeIDs = null;
            HashSet<Integer> i = this.fileIDs;
            synchronized (i) {
                if (this.fileIDs.isEmpty()) {
                    logger.debug((Object)"waitForReadyStatuses(): fileIDs is empty, breaking the loop");
                    break;
                }
            }
            i = this.sync;
            synchronized (i) {
                try {
                    int retrytime = this.rs.retryDeltaTime;
                    if (retrytime <= 0) {
                        retrytime = 5;
                    }
                    logger.debug((Object)("waitForReadyStatuses(): waiting for " + retrytime + " seconds before updating status ..."));
                    this.sync.wait((long)retrytime * 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            i = this.fileIDs;
            synchronized (i) {
                if (this.fileIDs.isEmpty()) {
                    break;
                }
            }
            this.rs = this.getRequestStatus(this.requestID);
            if (this.rs == null) {
                this.notifyOfFailure(" null requests status");
                return;
            }
            if (this.rs.state.equals("Failed")) {
                logger.error((Object)("rs.state = " + this.rs.state + " rs.error = " + this.rs.errorMessage));
                for (int i2 = 0; i2 < this.rs.fileStatuses.length; ++i2) {
                    logger.error((Object)("      ====> fileStatus state ==" + this.rs.fileStatuses[i2].state));
                }
                this.notifyOfFailure("rs.state = " + this.rs.state + " rs.error = " + this.rs.errorMessage);
                return;
            }
            if (this.rs.fileStatuses.length == this.number_of_file_reqs) continue;
            String err = "incorrect number of RequestFileStatusesin RequestStatus expected " + this.number_of_file_reqs + " received " + this.rs.fileStatuses.length;
            this.notifyOfFailure(err);
            return;
        }
    }

    private static RequestFileStatus getFileRequest(RequestStatus rs, Integer nextID) {
        RequestFileStatus[] frs = rs.fileStatuses;
        if (frs == null) {
            return null;
        }
        for (int i = 0; i < frs.length; ++i) {
            if (frs[i].fileId != nextID) continue;
            return frs[i];
        }
        return null;
    }

    protected abstract RequestStatus getInitialRequestStatus() throws Exception;

    protected RequestStatus getRequestStatus(int requestID) {
        return this.remoteSRM.getRequestStatus(requestID);
    }

    private boolean setFileStatus(int requestID, int fileId, String status) {
        RequestStatus srm_status = this.remoteSRM.setFileStatus(requestID, fileId, status);
        if (srm_status == null) {
            return false;
        }
        if (srm_status.requestId != requestID) {
            return false;
        }
        if (srm_status.fileStatuses == null) {
            return false;
        }
        for (int i = 0; i < srm_status.fileStatuses.length; ++i) {
            RequestFileStatus fileStatus = srm_status.fileStatuses[i];
            if (fileStatus.fileId != fileId) continue;
            return true;
        }
        return false;
    }

    public static void staticSetFileStatus(RequestCredential credential, String surl, int requestID, int fileId, String status, long retry_timeout, int retry_num, Transport transport) throws Exception {
        SRMClientV1 remoteSRM = new SRMClientV1(new SrmUrl(surl), credential.getDelegatedCredential(), retry_timeout, retry_num, true, true, transport);
        remoteSRM.setFileStatus(requestID, fileId, status);
    }
}

