/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.axis.types.URI;
import org.apache.log4j.Logger;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRMException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.client.Transport;
import org.dcache.srm.client.TurlGetterPutter;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.util.SrmUrl;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTGetFileRequest;
import org.dcache.srm.v2_2.ArrayOfTGetRequestFileStatus;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmPrepareToGetRequest;
import org.dcache.srm.v2_2.SrmPrepareToGetResponse;
import org.dcache.srm.v2_2.SrmReleaseFilesRequest;
import org.dcache.srm.v2_2.SrmReleaseFilesResponse;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestResponse;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TGetFileRequest;
import org.dcache.srm.v2_2.TGetRequestFileStatus;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;

public final class RemoteTurlGetterV2
extends TurlGetterPutter {
    private static final Logger logger = Logger.getLogger(RemoteTurlGetterV2.class);
    private ISRM srmv2;
    protected String[] SURLs;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    protected int number_of_file_reqs;
    protected boolean createdMap;
    private String requestToken;
    private long lifetime;
    SrmPrepareToGetResponse srmPrepareToGetResponse;
    private final Transport transport;
    long retry_timout;
    int retry_num;

    public RemoteTurlGetterV2(AbstractStorageElement storage, RequestCredential credential, String[] SURLs, String[] protocols, PropertyChangeListener listener, long retry_timeout, int retry_num, long lifetime, Transport transport) {
        super(storage, credential, protocols);
        this.SURLs = SURLs;
        this.number_of_file_reqs = SURLs.length;
        this.retry_num = retry_num;
        this.retry_timout = retry_timeout;
        this.lifetime = lifetime;
        this.transport = transport;
        this.addListener(listener);
    }

    protected void releaseFile(String surl) throws RemoteException, URI.MalformedURIException {
        SrmReleaseFilesRequest srmReleaseFilesRequest = new SrmReleaseFilesRequest();
        srmReleaseFilesRequest.setRequestToken(this.requestToken);
        URI[] surlArray = new URI[]{new URI(surl)};
        srmReleaseFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
        SrmReleaseFilesResponse srmReleaseFilesResponse = this.srmv2.srmReleaseFiles(srmReleaseFilesRequest);
        TReturnStatus returnStatus = srmReleaseFilesResponse.getReturnStatus();
        if (returnStatus == null) {
            logger.error((Object)"srmReleaseFiles return status is null");
            return;
        }
        logger.debug((Object)("srmReleaseFilesResponse status code=" + returnStatus.getStatusCode()));
    }

    @Override
    public void getInitialRequest() throws SRMException {
        if (this.number_of_file_reqs == 0) {
            logger.debug((Object)"number_of_file_reqs is 0, nothing to do");
            return;
        }
        logger.debug((Object)("SURLs[0] is " + this.SURLs[0]));
        try {
            SrmUrl srmUrl = new SrmUrl(this.SURLs[0]);
            this.srmv2 = new SRMClientV2(srmUrl, this.credential.getDelegatedCredential(), this.retry_timout, this.retry_num, true, true, this.transport);
            int len = this.SURLs.length;
            TGetFileRequest[] fileRequests = new TGetFileRequest[len];
            for (int i = 0; i < len; ++i) {
                URI surl = new URI(this.SURLs[i]);
                fileRequests[i] = new TGetFileRequest();
                fileRequests[i].setSourceSURL(surl);
                this.pendingSurlsToIndex.put(this.SURLs[i], i);
            }
            SrmPrepareToGetRequest srmPrepareToGetRequest = new SrmPrepareToGetRequest();
            srmPrepareToGetRequest.setDesiredTotalRequestTime((int)this.lifetime);
            TTransferParameters transferParameters = new TTransferParameters();
            transferParameters.setAccessPattern(TAccessPattern.TRANSFER_MODE);
            transferParameters.setConnectionType(TConnectionType.WAN);
            transferParameters.setArrayOfTransferProtocols(new ArrayOfString(this.protocols));
            srmPrepareToGetRequest.setTransferParameters(transferParameters);
            ArrayOfTGetFileRequest arrayOfTGetFileRequest = new ArrayOfTGetFileRequest();
            arrayOfTGetFileRequest.setRequestArray(fileRequests);
            srmPrepareToGetRequest.setArrayOfFileRequests(arrayOfTGetFileRequest);
            this.srmPrepareToGetResponse = this.srmv2.srmPrepareToGet(srmPrepareToGetRequest);
        }
        catch (Exception e) {
            logger.error((Object)("failed to connect to " + this.SURLs[0] + " " + e.getMessage()));
            throw new SRMException("failed to connect to " + this.SURLs[0], e);
        }
    }

    @Override
    public void run() {
        if (this.number_of_file_reqs == 0) {
            logger.debug((Object)"number_of_file_reqs is 0, nothing to do");
            return;
        }
        try {
            int len = this.SURLs.length;
            if (this.srmPrepareToGetResponse == null) {
                throw new IOException(" null srmPrepareToGetResponse");
            }
            TReturnStatus status = this.srmPrepareToGetResponse.getReturnStatus();
            if (status == null) {
                throw new IOException(" null return status");
            }
            TStatusCode statusCode = status.getStatusCode();
            if (statusCode == null) {
                throw new IOException(" null status code");
            }
            if (RequestStatusTool.isFailedRequestStatus(status)) {
                throw new IOException("srmPrepareToGet submission failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
            }
            this.requestToken = this.srmPrepareToGetResponse.getRequestToken();
            logger.debug((Object)(" srm returned requestToken = " + this.requestToken));
            ArrayOfTGetRequestFileStatus arrayOfTGetRequestFileStatus = this.srmPrepareToGetResponse.getArrayOfFileStatuses();
            if (arrayOfTGetRequestFileStatus == null) {
                throw new IOException("returned GetRequestFileStatuses is an empty array");
            }
            TGetRequestFileStatus[] getRequestFileStatuses = arrayOfTGetRequestFileStatus.getStatusArray();
            if (getRequestFileStatuses == null) {
                throw new IOException("returned GetRequestFileStatuses is an empty array");
            }
            if (getRequestFileStatuses.length != len) {
                throw new IOException("incorrect number of GetRequestFileStatusesin RequestStatus expected " + len + " received " + getRequestFileStatuses.length);
            }
            boolean haveCompletedFileRequests = false;
            while (!this.pendingSurlsToIndex.isEmpty()) {
                int expectedResponseLength;
                URI surl;
                long estimatedWaitInSeconds = Integer.MAX_VALUE;
                for (TGetRequestFileStatus getRequestFileStatus : getRequestFileStatuses) {
                    int indx;
                    surl = getRequestFileStatus.getSourceSURL();
                    if (surl == null) {
                        logger.error((Object)"invalid getRequestFileStatus, surl is null");
                        continue;
                    }
                    String surl_string = surl.toString();
                    if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                        logger.error((Object)("invalid getRequestFileStatus, surl = " + surl_string + " not found"));
                        continue;
                    }
                    TReturnStatus fileStatus = getRequestFileStatus.getStatus();
                    if (fileStatus == null) {
                        throw new IOException(" null file return status");
                    }
                    TStatusCode fileStatusCode = fileStatus.getStatusCode();
                    if (fileStatusCode == null) {
                        throw new IOException(" null file status code");
                    }
                    if (RequestStatusTool.isFailedFileRequestStatus(fileStatus)) {
                        String error = "retreval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                        logger.error((Object)error);
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.notifyOfFailure(this.SURLs[indx], error, this.requestToken, null);
                        haveCompletedFileRequests = true;
                        continue;
                    }
                    if (getRequestFileStatus.getTransferURL() != null) {
                        String transferUrl = getRequestFileStatus.getTransferURL().toString();
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        long size = 0L;
                        if (getRequestFileStatus.getFileSize() != null) {
                            size = getRequestFileStatus.getFileSize().longValue();
                        } else {
                            logger.error((Object)("size is not set in FileStatus for SURL=" + this.SURLs[indx]));
                        }
                        this.notifyOfTURL(this.SURLs[indx], transferUrl, this.requestToken, null, size);
                        haveCompletedFileRequests = true;
                        continue;
                    }
                    if (getRequestFileStatus.getEstimatedWaitTime() == null || (long)getRequestFileStatus.getEstimatedWaitTime().intValue() >= estimatedWaitInSeconds || getRequestFileStatus.getEstimatedWaitTime() < 1) continue;
                    estimatedWaitInSeconds = getRequestFileStatus.getEstimatedWaitTime().intValue();
                }
                if (this.pendingSurlsToIndex.isEmpty()) {
                    logger.debug((Object)"no more pending transfers, breaking the loop");
                    break;
                }
                if (estimatedWaitInSeconds > 60L) {
                    estimatedWaitInSeconds = 60L;
                }
                try {
                    logger.debug((Object)("sleeping " + estimatedWaitInSeconds + " seconds ..."));
                    Thread.sleep(estimatedWaitInSeconds * 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                SrmStatusOfGetRequestRequest srmStatusOfGetRequestRequest = new SrmStatusOfGetRequestRequest();
                srmStatusOfGetRequestRequest.setRequestToken(this.requestToken);
                if (haveCompletedFileRequests) {
                    String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                    expectedResponseLength = pendingSurlStrings.length;
                    URI[] surlArray = new URI[expectedResponseLength];
                    for (int i = 0; i < expectedResponseLength; ++i) {
                        URI surl2;
                        surlArray[i] = surl2 = new URI(pendingSurlStrings[i]);
                    }
                    srmStatusOfGetRequestRequest.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArray));
                } else {
                    expectedResponseLength = this.SURLs.length;
                    URI[] surlArray = new URI[expectedResponseLength];
                    for (int i = 0; i < expectedResponseLength; ++i) {
                        surlArray[i] = surl = new URI(this.SURLs[i]);
                    }
                    srmStatusOfGetRequestRequest.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArray));
                }
                SrmStatusOfGetRequestResponse srmStatusOfGetRequestResponse = this.srmv2.srmStatusOfGetRequest(srmStatusOfGetRequestRequest);
                if (srmStatusOfGetRequestResponse == null) {
                    throw new IOException(" null srmStatusOfGetRequestResponse");
                }
                arrayOfTGetRequestFileStatus = srmStatusOfGetRequestResponse.getArrayOfFileStatuses();
                if (arrayOfTGetRequestFileStatus == null) {
                    logger.error((Object)"incorrect number of RequestFileStatuses");
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                getRequestFileStatuses = arrayOfTGetRequestFileStatus.getStatusArray();
                if (getRequestFileStatuses == null || getRequestFileStatuses.length != expectedResponseLength) {
                    logger.error((Object)"incorrect number of RequestFileStatuses");
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                status = srmStatusOfGetRequestResponse.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (!RequestStatusTool.isFailedRequestStatus(status)) continue;
                throw new IOException("srmPrepareToGet update failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
            }
        }
        catch (IOException e) {
            logger.error((Object)e.toString());
            this.notifyOfFailure(e);
            return;
        }
        catch (SRMException srme) {
            logger.error((Object)srme.toString());
            this.notifyOfFailure(srme);
            return;
        }
    }

    public static void staticReleaseFile(RequestCredential credential, String surl, String requestTokenString, long retry_timeout, int retry_num, Transport transport) throws Exception {
        SrmUrl srmUrl = new SrmUrl(surl);
        SRMClientV2 srmv2 = new SRMClientV2(srmUrl, credential.getDelegatedCredential(), retry_timeout, retry_num, true, true, transport);
        String requestToken = requestTokenString;
        String[] surl_strings = new String[]{surl};
        URI[] surlArray = new URI[]{new URI(surl)};
        SrmReleaseFilesRequest srmReleaseFilesRequest = new SrmReleaseFilesRequest();
        srmReleaseFilesRequest.setRequestToken(requestToken);
        srmReleaseFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
        SrmReleaseFilesResponse srmReleaseFilesResponse = srmv2.srmReleaseFiles(srmReleaseFilesRequest);
        TReturnStatus returnStatus = srmReleaseFilesResponse.getReturnStatus();
        if (returnStatus == null) {
            logger.error((Object)"srmReleaseFiles return status is null");
            return;
        }
        logger.debug((Object)("srmReleaseFilesResponse status code=" + returnStatus.getStatusCode()));
    }
}

