/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.CopyJob;
import gov.fnal.srm.util.SRMClient;
import org.dcache.srm.Logger;
import org.globus.util.GlobusURL;

public class SimpleCopyJob
implements CopyJob {
    private GlobusURL from;
    private GlobusURL to;
    private boolean isDone;
    private SRMClient client;

    public SimpleCopyJob(GlobusURL from, GlobusURL to, Logger logger, SRMClient client) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("both source and destinationmust be non-null");
        }
        this.from = from;
        this.to = to;
        this.client = client;
    }

    @Override
    public GlobusURL getSource() {
        return this.from;
    }

    @Override
    public GlobusURL getDestination() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SimpleCopyJob)) {
            return false;
        }
        SimpleCopyJob copy_job = (SimpleCopyJob)o;
        return this.to.equals((Object)copy_job.to) && this.from.equals((Object)copy_job.from);
    }

    public String toString() {
        return "CopyJob, source = " + this.from.getURL() + " destination = " + this.to.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(boolean success, String error) {
        SimpleCopyJob simpleCopyJob = this;
        synchronized (simpleCopyJob) {
            if (this.isDone) {
                return;
            }
        }
        if (success) {
            this.client.setReportSucceeded(this.from, this.to);
        } else {
            error = "failed to copy: " + error;
            this.client.setReportFailed(this.from, this.to, error);
        }
        simpleCopyJob = this;
        synchronized (simpleCopyJob) {
            this.isDone = true;
        }
    }
}

