/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.CopyJob;
import gov.fnal.srm.util.SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.Logger;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmPutDoneRequest;
import org.dcache.srm.v2_2.SrmPutDoneResponse;
import org.dcache.srm.v2_2.SrmReleaseFilesRequest;
import org.dcache.srm.v2_2.SrmReleaseFilesResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.globus.util.GlobusURL;

public class SRMV2CopyJob
implements CopyJob {
    private GlobusURL from;
    private GlobusURL to;
    private ISRM srm;
    private boolean isDone;
    private Logger logger;
    private GlobusURL surl;
    private boolean isSrmPrepareToGet;
    private SRMClient client;
    private String requestToken;

    public SRMV2CopyJob(GlobusURL from, GlobusURL to, ISRM srm, String requestToken, Logger logger, GlobusURL surl, boolean isSrmPrepareToGet, SRMClient client) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("both source and destinationmust be non-null");
        }
        this.from = from;
        this.to = to;
        this.srm = srm;
        this.requestToken = requestToken;
        this.logger = logger;
        this.surl = surl;
        this.isSrmPrepareToGet = isSrmPrepareToGet;
        this.client = client;
    }

    public SRMV2CopyJob(GlobusURL from, GlobusURL to, Logger logger, GlobusURL surl, boolean isSrmPrepareToGet, SRMClient client) {
        this(from, to, null, null, logger, surl, isSrmPrepareToGet, client);
    }

    @Override
    public GlobusURL getSource() {
        return this.from;
    }

    @Override
    public GlobusURL getDestination() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SRMV2CopyJob)) {
            return false;
        }
        SRMV2CopyJob copy_job = (SRMV2CopyJob)o;
        return this.to.equals((Object)copy_job.to) && this.from.equals((Object)copy_job.from);
    }

    public String toString() {
        return "CopyJob, source = " + this.from.getURL() + " destination = " + this.to.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(boolean success, String error) {
        SRMV2CopyJob sRMV2CopyJob = this;
        synchronized (sRMV2CopyJob) {
            if (this.isDone) {
                return;
            }
        }
        if (success) {
            if (this.isSrmPrepareToGet) {
                this.client.setReportSucceeded(this.surl, null);
            } else {
                this.client.setReportSucceeded(null, this.surl);
            }
        } else {
            error = "received TURL but failed to copy: " + error;
            if (this.isSrmPrepareToGet) {
                this.client.setReportFailed(this.surl, null, error);
            } else {
                this.client.setReportFailed(null, this.surl, error);
            }
        }
        if (this.srm != null) {
            try {
                URI[] surlArray = new URI[]{new URI(this.surl.getURL())};
                if (success) {
                    if (this.isSrmPrepareToGet) {
                        SrmReleaseFilesRequest srmReleaseFilesRequest = new SrmReleaseFilesRequest();
                        srmReleaseFilesRequest.setRequestToken(this.requestToken);
                        srmReleaseFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                        SrmReleaseFilesResponse srmReleaseFilesResponse = this.srm.srmReleaseFiles(srmReleaseFilesRequest);
                        TReturnStatus returnStatus = srmReleaseFilesResponse.getReturnStatus();
                        if (returnStatus == null) {
                            this.logger.elog("srmReleaseFilesResponse return status is null");
                            return;
                        }
                        this.logger.log("srmReleaseFilesResponse status code=" + returnStatus.getStatusCode());
                    } else {
                        SrmPutDoneRequest srmPutDoneRequest = new SrmPutDoneRequest();
                        srmPutDoneRequest.setRequestToken(this.requestToken);
                        srmPutDoneRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                        SrmPutDoneResponse srmPutDoneResponse = this.srm.srmPutDone(srmPutDoneRequest);
                        TReturnStatus returnStatus = srmPutDoneResponse.getReturnStatus();
                        if (returnStatus == null) {
                            this.logger.elog("srmPutDone return status is null");
                            return;
                        }
                        this.logger.log("srmPutDone status code=" + returnStatus.getStatusCode());
                    }
                } else {
                    SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
                    srmAbortFilesRequest.setRequestToken(this.requestToken);
                    srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                    SrmAbortFilesResponse srmAbortFilesResponse = this.srm.srmAbortFiles(srmAbortFilesRequest);
                    if (srmAbortFilesResponse == null) {
                        this.logger.elog(" srmAbortFilesResponse is null");
                    } else {
                        TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                        if (returnStatus == null) {
                            this.logger.elog("srmAbortFiles return status is null");
                            return;
                        }
                        this.logger.log("srmAbortFiles status code=" + returnStatus.getStatusCode());
                    }
                }
            }
            catch (Exception e) {
                this.logger.elog(e.toString());
            }
        }
        sRMV2CopyJob = this;
        synchronized (sRMV2CopyJob) {
            this.isDone = true;
        }
    }
}

