/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import diskCacheV111.srm.ISRM;
import gov.fnal.srm.util.CopyJob;
import gov.fnal.srm.util.SRMClient;
import org.dcache.srm.Logger;
import org.globus.util.GlobusURL;

public class SRMV1CopyJob
implements CopyJob {
    private GlobusURL from;
    private GlobusURL to;
    private ISRM srm;
    private int requestID;
    private int fileID;
    private boolean isDone;
    private Logger logger;
    private GlobusURL surl;
    private boolean isSrmPrepareToGet;
    private SRMClient client;

    public SRMV1CopyJob(GlobusURL from, GlobusURL to, ISRM srm, int requestID, int fileID, Logger logger, GlobusURL surl, boolean isSrmPrepareToGet, SRMClient client) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("both source and destinationmust be non-null");
        }
        this.from = from;
        this.to = to;
        this.srm = srm;
        this.requestID = requestID;
        this.fileID = fileID;
        this.logger = logger;
        this.surl = surl;
        this.isSrmPrepareToGet = isSrmPrepareToGet;
        this.client = client;
    }

    public SRMV1CopyJob(GlobusURL from, GlobusURL to, Logger logger, GlobusURL surl, boolean isSrmPrepareToGet, SRMClient client) {
        this(from, to, null, 0, 0, logger, surl, isSrmPrepareToGet, client);
    }

    @Override
    public GlobusURL getSource() {
        return this.from;
    }

    @Override
    public GlobusURL getDestination() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SRMV1CopyJob)) {
            return false;
        }
        SRMV1CopyJob copy_job = (SRMV1CopyJob)o;
        return this.to.equals((Object)copy_job.to) && this.from.equals((Object)copy_job.from);
    }

    public String toString() {
        return "CopyJob, source = " + this.from.getURL() + " destination = " + this.to.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(boolean success, String error) {
        SRMV1CopyJob sRMV1CopyJob = this;
        synchronized (sRMV1CopyJob) {
            if (this.isDone) {
                return;
            }
        }
        if (success) {
            if (this.isSrmPrepareToGet) {
                this.client.setReportSucceeded(this.surl, null);
            } else {
                this.client.setReportSucceeded(null, this.surl);
            }
        } else {
            error = "received TURL but failed to copy: " + error;
            if (this.isSrmPrepareToGet) {
                this.client.setReportFailed(this.surl, null, error);
            } else {
                this.client.setReportFailed(null, this.surl, error);
            }
        }
        if (this.srm != null) {
            this.logger.log("setting file request " + this.fileID + " status to Done");
            this.srm.setFileStatus(this.requestID, this.fileID, "Done");
        }
        sRMV1CopyJob = this;
        synchronized (sRMV1CopyJob) {
            this.isDone = true;
        }
    }
}

