/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.globus.util.GlobusURL;

public class SRMStageClientV1
extends SRMClient
implements Runnable {
    private String[] protocols;
    GlobusURL[] from;
    private HashSet<Integer> fileIDs = new HashSet();
    private HashMap<Integer, RequestFileStatus> fileIDsMap = new HashMap();
    private int requestID;
    private Thread hook;

    public SRMStageClientV1(Configuration configuration, GlobusURL[] from) {
        super(configuration);
        this.report = new Report(from, from, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
    }

    @Override
    public void connect() throws Exception {
        this.connect(this.from[0]);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            int len = this.from.length;
            String[] SURLS = new String[len];
            for (int i = 0; i < len; ++i) {
                SURLS[i] = this.from[i].getURL();
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            RequestStatus rs = this.srm.get(SURLS, this.protocols);
            if (rs == null) {
                throw new IOException(" null requests status");
            }
            this.requestID = rs.requestId;
            this.dsay(" srm returned requestId = " + rs.requestId);
            try {
                if (rs.state.equals("Failed")) {
                    this.esay("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                    for (int i = 0; i < rs.fileStatuses.length; ++i) {
                        this.edsay("      ====> fileStatus state ==" + rs.fileStatuses[i].state);
                    }
                    throw new IOException("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                }
                if (rs.fileStatuses.length != len) {
                    this.esay("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                    throw new IOException("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                }
                for (int i = 0; i < len; ++i) {
                    Integer fileId = new Integer(rs.fileStatuses[i].fileId);
                    this.fileIDs.add(fileId);
                    this.fileIDsMap.put(fileId, rs.fileStatuses[i]);
                }
                while (!this.fileIDs.isEmpty()) {
                    int i;
                    Iterator<Integer> iter = this.fileIDs.iterator();
                    HashSet<Integer> removeIDs = new HashSet<Integer>();
                    while (iter.hasNext()) {
                        GlobusURL surl;
                        Integer nextID = iter.next();
                        RequestFileStatus frs = SRMStageClientV1.getFileRequest(rs, nextID);
                        if (frs == null) {
                            throw new IOException("request status does not haveRequestFileStatus fileID = " + nextID);
                        }
                        if (frs.state.equals("Failed")) {
                            removeIDs.add(nextID);
                            surl = new GlobusURL(frs.SURL);
                            this.setReportFailed(surl, surl, rs.errorMessage);
                            this.esay("staging of SURL " + frs.SURL + " failed: File Status is \"Failed\"");
                            continue;
                        }
                        if (!frs.state.equals("Ready")) continue;
                        this.say(frs.SURL + " is staged successfully ");
                        surl = new GlobusURL(frs.SURL);
                        removeIDs.add(nextID);
                        this.srm.setFileStatus(rs.requestId, nextID, "Done");
                        this.setReportSucceeded(surl, surl);
                    }
                    this.fileIDs.removeAll(removeIDs);
                    removeIDs = null;
                    if (this.fileIDs.isEmpty()) {
                        this.dsay("fileIDs is empty, breaking the loop");
                        Runtime.getRuntime().removeShutdownHook(this.hook);
                        break;
                    }
                    try {
                        int retrytime = rs.retryDeltaTime;
                        if (retrytime <= 0) {
                            retrytime = 1;
                        }
                        this.say("sleeping " + retrytime + " seconds ...");
                        Thread.sleep(retrytime * 1000);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    rs = this.srm.getRequestStatus(this.requestID);
                    if (rs == null) {
                        throw new IOException(" null requests status");
                    }
                    if (rs.fileStatuses.length != len) {
                        this.esay("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                        throw new IOException("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                    }
                    for (i = 0; i < len; ++i) {
                        this.fileIDsMap.put(new Integer(rs.fileStatuses[i].fileId), rs.fileStatuses[i]);
                    }
                    if (!rs.state.equals("Failed")) continue;
                    this.esay("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                    for (i = 0; i < rs.fileStatuses.length; ++i) {
                        this.edsay("      ====> fileStatus state ==" + rs.fileStatuses[i].state);
                    }
                    throw new IOException("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                }
            }
            catch (IOException ioe) {
                this.done(rs, this.srm);
                throw ioe;
            }
        }
        finally {
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm stage of at least one file failed or not completed");
                System.exit(1);
            }
        }
    }

    @Override
    public void run() {
        this.say("setting all remaining file statuses to \"Done\"");
        while (!this.fileIDs.isEmpty()) {
            Integer fileId = this.fileIDs.iterator().next();
            this.fileIDs.remove(fileId);
            this.say("setting file request " + fileId + " status to Done");
            RequestFileStatus rfs = this.fileIDsMap.get(fileId);
            this.srm.setFileStatus(this.requestID, rfs.fileId, "Done");
        }
        this.say("set all file statuses to \"Done\"");
    }
}

