/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmRmdirRequest;
import org.dcache.srm.v2_2.SrmRmdirResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMRmdirClientV2
extends SRMClient {
    private GSSCredential cred = null;
    private GlobusURL surl;
    private String surl_string;
    private ISRM isrm;

    public SRMRmdirClientV2(Configuration configuration, GlobusURL surl, String surl_string) {
        super(configuration);
        this.surl = surl;
        this.surl_string = surl_string;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surl;
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        SrmRmdirRequest req = new SrmRmdirRequest();
        if (this.configuration.isRecursive()) {
            req.setRecursive(Boolean.TRUE);
        } else {
            req.setRecursive(Boolean.FALSE);
        }
        URI uri = new URI(this.surl_string);
        req.setSURL(uri);
        SrmRmdirResponse resp = this.isrm.srmRmdir(req);
        TReturnStatus rs = resp.getReturnStatus();
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            TStatusCode rc = rs.getStatusCode();
            StringBuffer sb = new StringBuffer();
            sb.append("Return code: " + rc.toString() + "\n");
            sb.append("Explanation: " + rs.getExplanation() + "\n");
            System.out.println(sb.toString());
            System.exit(1);
        }
    }
}

