/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.request.AccessLatency;
import org.dcache.srm.request.RetentionPolicy;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortRequestRequest;
import org.dcache.srm.v2_2.SrmAbortRequestResponse;
import org.dcache.srm.v2_2.SrmReserveSpaceRequest;
import org.dcache.srm.v2_2.SrmReserveSpaceResponse;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMReserveSpaceClientV2
extends SRMClient
implements Runnable {
    private GlobusURL srmURL;
    SrmReserveSpaceRequest request = new SrmReserveSpaceRequest();
    private GSSCredential credential = null;
    private ISRM srmv2;
    private Thread hook;
    private String requestToken;

    public SRMReserveSpaceClientV2(Configuration configuration, GlobusURL url) {
        super(configuration);
        this.srmURL = url;
        try {
            this.credential = this.getGssCredential();
        }
        catch (Exception e) {
            this.credential = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        this.srmv2 = new SRMClientV2(this.srmURL, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        try {
            TAccessLatency al;
            TRetentionPolicy rp = this.configuration.getRetentionPolicy() != null ? RetentionPolicy.fromString(this.configuration.getRetentionPolicy()).toTRetentionPolicy() : null;
            TAccessLatency tAccessLatency = al = this.configuration.getAccessLatency() != null ? AccessLatency.fromString(this.configuration.getAccessLatency()).toTAccessLatency() : null;
            if (al != null && rp == null) {
                throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
            }
            if (rp != null) {
                this.request.setRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
            }
            if (this.configuration.getDesiredReserveSpaceSize() != null) {
                this.request.setDesiredSizeOfTotalSpace(new UnsignedLong(this.configuration.getDesiredReserveSpaceSize().longValue()));
            }
            if (this.configuration.getGuaranteedReserveSpaceSize() != null) {
                this.request.setDesiredSizeOfGuaranteedSpace(new UnsignedLong(this.configuration.getGuaranteedReserveSpaceSize().longValue()));
            }
            this.request.setUserSpaceTokenDescription(this.configuration.getSpaceTokenDescription());
            if (this.configuration.getDesiredLifetime() != null) {
                this.request.setDesiredLifetimeOfReservedSpace(new Integer((int)this.configuration.getDesiredLifetime().longValue()));
            }
            if (this.configuration.getArrayOfClientNetworks() != null || this.configuration.getConnectionType() != null || this.configuration.getAccessPattern() != null || this.configuration.getProtocols() != null) {
                TTransferParameters tp = new TTransferParameters();
                if (this.configuration.getArrayOfClientNetworks() != null) {
                    tp.setArrayOfClientNetworks(new ArrayOfString(this.configuration.getArrayOfClientNetworks()));
                }
                if (this.configuration.getConnectionType() != null) {
                    tp.setConnectionType(TConnectionType.fromString(this.configuration.getConnectionType()));
                }
                if (this.configuration.getAccessPattern() != null) {
                    tp.setAccessPattern(TAccessPattern.fromString(this.configuration.getAccessPattern()));
                }
                if (this.configuration.getProtocols() != null) {
                    tp.setArrayOfTransferProtocols(new ArrayOfString(this.configuration.getProtocols()));
                }
                this.request.setTransferParameters(tp);
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            SrmReserveSpaceResponse response = this.srmv2.srmReserveSpace(this.request);
            if (response == null) {
                throw new IOException(" null SrmReserveSpace");
            }
            TReturnStatus rs = response.getReturnStatus();
            this.requestToken = response.getRequestToken();
            this.dsay(" srm returned requestToken = " + this.requestToken);
            if (rs == null) {
                throw new IOException(" null TReturnStatus ");
            }
            if (RequestStatusTool.isFailedRequestStatus(rs)) {
                throw new IOException("srmReserveSpace submission failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
            }
            if (response.getSpaceToken() != null) {
                System.out.println("Space token =" + response.getSpaceToken());
                this.logger.log("lifetime = " + response.getLifetimeOfReservedSpace());
                if (response.getRetentionPolicyInfo() != null) {
                    this.logger.log("access latency = " + response.getRetentionPolicyInfo().getAccessLatency());
                    this.logger.log("retention policy = " + response.getRetentionPolicyInfo().getRetentionPolicy());
                }
                this.logger.log("guaranteed size = " + response.getSizeOfGuaranteedReservedSpace());
                this.logger.log("total size = " + response.getSizeOfTotalReservedSpace());
            } else {
                while (true) {
                    long estimatedWaitInSeconds;
                    if ((estimatedWaitInSeconds = 5L) > 60L) {
                        estimatedWaitInSeconds = 60L;
                    }
                    try {
                        this.say("sleeping " + estimatedWaitInSeconds + " seconds ...");
                        Thread.sleep(estimatedWaitInSeconds * 1000L);
                    }
                    catch (InterruptedException ie) {
                        System.out.println("Interrupted, quitting");
                        if (this.requestToken != null) {
                            this.abortRequest();
                        }
                        System.exit(1);
                    }
                    SrmStatusOfReserveSpaceRequestRequest req = new SrmStatusOfReserveSpaceRequestRequest();
                    req.setRequestToken(this.requestToken);
                    req.setAuthorizationID(this.request.getAuthorizationID());
                    SrmStatusOfReserveSpaceRequestResponse statusOfReserveSpaceRequestResponse = this.srmv2.srmStatusOfReserveSpaceRequest(req);
                    if (statusOfReserveSpaceRequestResponse == null) {
                        throw new IOException(" null statusOfReserveSpaceRequestResponse");
                    }
                    TReturnStatus status = statusOfReserveSpaceRequestResponse.getReturnStatus();
                    if (status == null) {
                        throw new IOException(" null return status");
                    }
                    if (status.getStatusCode() == null) {
                        throw new IOException(" null status code");
                    }
                    if (RequestStatusTool.isFailedRequestStatus(status)) {
                        this.logger.log("status: code=" + status.getStatusCode() + " explanantion=" + status.getExplanation());
                        throw new IOException("SrmStatusOfReserveSpaceRequest unexpected or failed status : " + status.getStatusCode() + " explanation=" + status.getExplanation());
                    }
                    if (status.getStatusCode() == TStatusCode.SRM_SUCCESS || status.getStatusCode() == TStatusCode.SRM_SPACE_AVAILABLE || status.getStatusCode() == TStatusCode.SRM_LOWER_SPACE_GRANTED) {
                        System.out.println("Space token =" + statusOfReserveSpaceRequestResponse.getSpaceToken());
                        this.logger.log("lifetime = " + statusOfReserveSpaceRequestResponse.getLifetimeOfReservedSpace());
                        this.logger.log("access latency = " + statusOfReserveSpaceRequestResponse.getRetentionPolicyInfo().getAccessLatency());
                        this.logger.log("retention policy = " + statusOfReserveSpaceRequestResponse.getRetentionPolicyInfo().getRetentionPolicy());
                        this.logger.log("guaranteed size = " + statusOfReserveSpaceRequestResponse.getSizeOfGuaranteedReservedSpace());
                        this.logger.log("total size = " + statusOfReserveSpaceRequestResponse.getSizeOfTotalReservedSpace());
                        break;
                    }
                    if (statusOfReserveSpaceRequestResponse.getEstimatedProcessingTime() == null || (long)statusOfReserveSpaceRequestResponse.getEstimatedProcessingTime().intValue() >= estimatedWaitInSeconds || statusOfReserveSpaceRequestResponse.getEstimatedProcessingTime() < 1) continue;
                    estimatedWaitInSeconds = statusOfReserveSpaceRequestResponse.getEstimatedProcessingTime().intValue();
                }
            }
            Runtime.getRuntime().removeShutdownHook(this.hook);
        }
        catch (Exception e) {
            try {
                if (this.requestToken != null) {
                    this.abortRequest();
                }
            }
            catch (Exception e1) {
                this.edsay(e1.toString());
            }
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            this.dsay("stopping ");
            if (this.requestToken != null) {
                this.abortRequest();
            }
        }
        catch (Exception e) {
            this.logger.elog(e.toString());
        }
    }

    public void abortRequest() throws Exception {
        SrmAbortRequestRequest abortRequest = new SrmAbortRequestRequest();
        abortRequest.setRequestToken(this.requestToken);
        SrmAbortRequestResponse abortResponse = this.srmv2.srmAbortRequest(abortRequest);
        if (abortResponse == null) {
            this.logger.elog(" SrmAbort is null");
        } else {
            TReturnStatus returnStatus = abortResponse.getReturnStatus();
            if (returnStatus == null) {
                this.esay("srmAbort return status is null");
                return;
            }
            this.say("srmAbortRequest status code=" + returnStatus.getStatusCode());
        }
    }
}

