/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Copier;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import gov.fnal.srm.util.SRMDispatcher;
import gov.fnal.srm.util.SRMV2CopyJob;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.request.AccessLatency;
import org.dcache.srm.request.FileStorageType;
import org.dcache.srm.request.RetentionPolicy;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ArrayOfTPutFileRequest;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmPrepareToPutRequest;
import org.dcache.srm.v2_2.SrmPrepareToPutResponse;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TPutFileRequest;
import org.dcache.srm.v2_2.TPutRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.globus.util.GlobusURL;

public class SRMPutClientV2
extends SRMClient
implements Runnable {
    private GlobusURL[] from;
    private GlobusURL[] to;
    private String[] protocols;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    private Copier copier;
    private Thread hook;
    private ISRM srmv2;
    private String requestToken;
    private SrmPrepareToPutResponse response;

    public SRMPutClientV2(Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
        this.to = to;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.to[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        try {
            TAccessLatency al;
            this.copier = new Copier(this.urlcopy, this.configuration);
            this.copier.setDebug(this.debug);
            new Thread(this.copier).start();
            int len = this.from.length;
            TPutFileRequest[] fileRequests = new TPutFileRequest[len];
            String[] SURLS = new String[len];
            for (int i = 0; i < len; ++i) {
                GlobusURL filesource = this.from[i];
                int filetype = SRMDispatcher.getUrlType(filesource);
                if ((filetype & 8) == 0) {
                    throw new IOException(" source is not file " + filesource.getURL());
                }
                if ((filetype & 0x80) == 128) {
                    throw new IOException(" source is directory " + filesource.getURL());
                }
                if ((filetype & 0x20) == 0) {
                    throw new IOException(" source is not readable " + filesource.getURL());
                }
                File f = new File(filesource.getPath());
                long filesize = f.length();
                SURLS[i] = this.to[i].getURL();
                URI uri = new URI(SURLS[i]);
                fileRequests[i] = new TPutFileRequest();
                fileRequests[i].setExpectedFileSize(new UnsignedLong(filesize));
                fileRequests[i].setTargetSURL(uri);
                this.pendingSurlsToIndex.put(SURLS[i], new Integer(i));
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            SrmPrepareToPutRequest srmPrepareToPutRequest = new SrmPrepareToPutRequest();
            String storagetype = this.configuration.getStorageType();
            if (storagetype != null) {
                srmPrepareToPutRequest.setDesiredFileStorageType(FileStorageType.fromString(storagetype.toUpperCase()).toTFileStorageType());
            }
            srmPrepareToPutRequest.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
            srmPrepareToPutRequest.setArrayOfFileRequests(new ArrayOfTPutFileRequest(fileRequests));
            TAccessPattern ap = null;
            if (this.configuration.getAccessPattern() != null) {
                ap = TAccessPattern.fromString(this.configuration.getAccessPattern());
            }
            TConnectionType ct = null;
            if (this.configuration.getConnectionType() != null) {
                ct = TConnectionType.fromString(this.configuration.getConnectionType());
            }
            ArrayOfString protocolArray = null;
            if (this.protocols != null) {
                protocolArray = new ArrayOfString(this.protocols);
            }
            ArrayOfString arrayOfClientNetworks = null;
            if (this.configuration.getArrayOfClientNetworks() != null) {
                arrayOfClientNetworks = new ArrayOfString(this.configuration.getArrayOfClientNetworks());
            }
            if (ap != null || ct != null || arrayOfClientNetworks != null || protocolArray != null) {
                srmPrepareToPutRequest.setTransferParameters(new TTransferParameters(ap, ct, arrayOfClientNetworks, protocolArray));
            }
            TRetentionPolicy rp = this.configuration.getRetentionPolicy() != null ? RetentionPolicy.fromString(this.configuration.getRetentionPolicy()).toTRetentionPolicy() : null;
            TAccessLatency tAccessLatency = al = this.configuration.getAccessLatency() != null ? AccessLatency.fromString(this.configuration.getAccessLatency()).toTAccessLatency() : null;
            if (al != null && rp == null) {
                throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
            }
            if (rp != null) {
                srmPrepareToPutRequest.setTargetFileRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
            }
            if (this.configuration.getOverwriteMode() != null) {
                srmPrepareToPutRequest.setOverwriteOption(TOverwriteMode.fromString(this.configuration.getOverwriteMode()));
            }
            if (this.configuration.getSpaceToken() != null) {
                srmPrepareToPutRequest.setTargetSpaceToken(this.configuration.getSpaceToken());
            }
            if (this.configuration.getExtraParameters().size() > 0) {
                TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                int counter = 0;
                Map<String, String> extraParameters = this.configuration.getExtraParameters();
                for (String key : extraParameters.keySet()) {
                    String value = extraParameters.get(key);
                    extraInfoArray[counter++] = new TExtraInfo(key, value);
                }
                ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                srmPrepareToPutRequest.setStorageSystemInfo(arrayOfExtraInfo);
            }
            this.response = this.srmv2.srmPrepareToPut(srmPrepareToPutRequest);
            if (this.response == null) {
                throw new IOException(" null response");
            }
            TReturnStatus status = this.response.getReturnStatus();
            if (status == null) {
                throw new IOException(" null return status");
            }
            TStatusCode statusCode = status.getStatusCode();
            if (statusCode == null) {
                throw new IOException(" null status code");
            }
            String explanation = status.getExplanation();
            if (RequestStatusTool.isFailedRequestStatus(status)) {
                if (explanation != null) {
                    throw new IOException("srmPrepareToPut submission failed, unexpected or failed status : " + statusCode + " explanation= " + explanation);
                }
                throw new IOException("srmPrepareToPut submission failed, unexpected or failed status : " + statusCode);
            }
            this.requestToken = this.response.getRequestToken();
            this.dsay(" srm returned requestToken = " + this.requestToken);
            if (this.response.getArrayOfFileStatuses() == null) {
                throw new IOException("returned PutRequestFileStatuses is an empty array");
            }
            TPutRequestFileStatus[] putRequestFileStatuses = this.response.getArrayOfFileStatuses().getStatusArray();
            if (putRequestFileStatuses.length != len) {
                throw new IOException("incorrect number of GetRequestFileStatusesin RequestStatus expected " + len + " received " + putRequestFileStatuses.length);
            }
            while (!this.pendingSurlsToIndex.isEmpty()) {
                long estimatedWaitInSeconds = 5L;
                for (int i = 0; i < len; ++i) {
                    int indx;
                    TPutRequestFileStatus putRequestFileStatus = putRequestFileStatuses[i];
                    URI surl = putRequestFileStatus.getSURL();
                    if (surl == null) {
                        this.esay("invalid putRequestFileStatus, surl is null");
                        continue;
                    }
                    String surl_string = surl.toString();
                    if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                        this.esay("invalid putRequestFileStatus, surl = " + surl_string + " not found");
                        continue;
                    }
                    TReturnStatus fileStatus = putRequestFileStatus.getStatus();
                    if (fileStatus == null) {
                        throw new IOException(" null file return status");
                    }
                    TStatusCode fileStatusCode = fileStatus.getStatusCode();
                    if (fileStatusCode == null) {
                        throw new IOException(" null file status code");
                    }
                    if (RequestStatusTool.isFailedFileRequestStatus(fileStatus)) {
                        String error = "retrieval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                        this.esay(error);
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.setReportFailed(this.from[indx], this.to[indx], error);
                        continue;
                    }
                    if (putRequestFileStatus.getTransferURL() != null && putRequestFileStatus.getTransferURL() != null) {
                        GlobusURL globusTURL = new GlobusURL(putRequestFileStatus.getTransferURL().toString());
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.setReportFailed(this.from[indx], this.to[indx], "received TURL, but did not complete transfer");
                        SRMV2CopyJob job = new SRMV2CopyJob(this.from[indx], globusTURL, this.srmv2, this.requestToken, this.logger, this.to[indx], false, this);
                        this.copier.addCopyJob(job);
                        continue;
                    }
                    if (putRequestFileStatus.getEstimatedWaitTime() == null || (long)putRequestFileStatus.getEstimatedWaitTime().intValue() >= estimatedWaitInSeconds || putRequestFileStatus.getEstimatedWaitTime() < 1) continue;
                    estimatedWaitInSeconds = putRequestFileStatus.getEstimatedWaitTime().intValue();
                }
                if (this.pendingSurlsToIndex.isEmpty()) {
                    this.dsay("no more pending transfers, breaking the loop");
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    break;
                }
                if (estimatedWaitInSeconds > 60L) {
                    estimatedWaitInSeconds = 60L;
                }
                try {
                    this.say("sleeping " + estimatedWaitInSeconds + " seconds ...");
                    Thread.sleep(estimatedWaitInSeconds * 1000L);
                }
                catch (InterruptedException ie) {
                    this.logger.elog(ie.toString());
                }
                SrmStatusOfPutRequestRequest srmStatusOfPutRequestRequest = new SrmStatusOfPutRequestRequest();
                srmStatusOfPutRequestRequest.setRequestToken(this.requestToken);
                String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                int expectedResponseLength = pendingSurlStrings.length;
                URI[] surlArray = new URI[expectedResponseLength];
                for (int i = 0; i < expectedResponseLength; ++i) {
                    surlArray[i] = new URI(pendingSurlStrings[i]);
                }
                srmStatusOfPutRequestRequest.setArrayOfTargetSURLs(new ArrayOfAnyURI(surlArray));
                SrmStatusOfPutRequestResponse srmStatusOfPutRequestResponse = this.srmv2.srmStatusOfPutRequest(srmStatusOfPutRequestRequest);
                if (srmStatusOfPutRequestResponse == null) {
                    throw new IOException(" null srmStatusOfPutRequestResponse");
                }
                if (srmStatusOfPutRequestResponse.getArrayOfFileStatuses() == null) {
                    this.esay("putRequestFileStatuses == null");
                    throw new IOException("putRequestFileStatuses == null");
                }
                putRequestFileStatuses = srmStatusOfPutRequestResponse.getArrayOfFileStatuses().getStatusArray();
                if (putRequestFileStatuses.length != expectedResponseLength) {
                    this.esay("incorrect number of RequestFileStatuses");
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                status = srmStatusOfPutRequestResponse.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (!RequestStatusTool.isFailedRequestStatus(status)) continue;
                String error = "srmPrepareToPut update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                this.esay(error);
                for (int i = 0; i < expectedResponseLength; ++i) {
                    TReturnStatus frstatus = putRequestFileStatuses[i].getStatus();
                    if (frstatus == null) continue;
                    this.esay("PutFileRequest[" + putRequestFileStatuses[i].getSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                    if (RequestStatusTool.isTransientStateStatus(frstatus)) continue;
                    this.pendingSurlsToIndex.remove(putRequestFileStatuses[i].getSURL().toString());
                }
                throw new IOException(error);
            }
        }
        catch (Exception e) {
            try {
                if (this.copier != null) {
                    this.dsay("stopping copier" + e);
                    this.copier.stop();
                    this.abortAllPendingFiles();
                }
            }
            catch (Exception e1) {
                this.edsay(e1.toString());
            }
            throw e;
        }
        finally {
            if (this.copier != null) {
                this.copier.doneAddingJobs();
                try {
                    this.copier.waitCompletion();
                }
                catch (Exception e1) {
                    this.edsay(e1.toString());
                }
            }
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm copy of at least one file failed or not completed");
            }
        }
    }

    @Override
    public void run() {
        try {
            this.dsay("stopping copier");
            this.copier.stop();
            this.abortAllPendingFiles();
        }
        catch (Exception e) {
            this.logger.elog(e.toString());
        }
    }

    private void abortAllPendingFiles() throws Exception {
        if (this.pendingSurlsToIndex.isEmpty()) {
            return;
        }
        if (this.response != null) {
            this.requestToken = this.response.getRequestToken();
            if (this.requestToken != null) {
                String[] surl_strings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                int len = surl_strings.length;
                this.say("Releasing all remaining file requests");
                URI[] surlArray = new URI[len];
                for (int i = 0; i < len; ++i) {
                    surlArray[i] = new URI(surl_strings[i]);
                }
                SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
                srmAbortFilesRequest.setRequestToken(this.requestToken);
                srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
                if (srmAbortFilesResponse == null) {
                    this.logger.elog(" srmAbortFilesResponse is null");
                } else {
                    TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                    if (returnStatus == null) {
                        this.esay("srmAbortFiles return status is null");
                        return;
                    }
                    this.say("srmAbortFiles status code=" + returnStatus.getStatusCode());
                }
            } else if (this.response.getArrayOfFileStatuses() != null && this.response.getArrayOfFileStatuses().getStatusArray() != null) {
                for (int i = 0; i < this.response.getArrayOfFileStatuses().getStatusArray().length; ++i) {
                    URI surl = this.response.getArrayOfFileStatuses().getStatusArray(i).getSURL();
                    TReturnStatus fst = this.response.getArrayOfFileStatuses().getStatusArray(i).getStatus();
                    this.esay("SURL[" + i + "]=" + surl.toString() + " status=" + fst.getStatusCode() + " explanation=" + fst.getExplanation());
                }
            }
        }
    }
}

