/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmPingRequest;
import org.dcache.srm.v2_2.SrmPingResponse;
import org.dcache.srm.v2_2.TExtraInfo;
import org.globus.util.GlobusURL;

public class SRMPingClientV2
extends SRMClient {
    private ISRM srmv2;
    GlobusURL srmurl;

    public SRMPingClientV2(Configuration configuration, GlobusURL srmurl) {
        super(configuration);
        this.srmurl = srmurl;
    }

    @Override
    public void connect() throws Exception {
        this.srmv2 = new SRMClientV2(this.srmurl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        ArrayOfTExtraInfo info;
        SrmPingRequest request = new SrmPingRequest();
        SrmPingResponse response = this.srmv2.srmPing(request);
        this.say("received response");
        if (response == null) {
            throw new IOException(" null response");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("VersionInfo : " + response.getVersionInfo() + "\n");
        if (response.getOtherInfo() != null && (info = response.getOtherInfo()).getExtraInfoArray() != null) {
            for (int i = 0; i < info.getExtraInfoArray().length; ++i) {
                TExtraInfo extraInfo = info.getExtraInfoArray()[i];
                sb.append(extraInfo.getKey() + ":" + extraInfo.getValue() + "\n");
            }
        }
        System.out.println(sb.toString());
    }
}

