/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortRequestRequest;
import org.dcache.srm.v2_2.SrmAbortRequestResponse;
import org.dcache.srm.v2_2.SrmLsRequest;
import org.dcache.srm.v2_2.SrmLsResponse;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TFileLocality;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TFileType;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TMetaDataPathDetail;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TUserPermission;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMLsClientV2
extends SRMClient
implements Runnable {
    private GSSCredential cred = null;
    private GlobusURL[] surls;
    private String[] surl_strings;
    private ISRM isrm;
    private String requestToken;
    private Thread hook;

    public SRMLsClientV2(Configuration configuration, GlobusURL[] surls, String[] surl_strings) {
        super(configuration);
        this.surls = surls;
        this.surl_strings = surl_strings;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surls[0];
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        block36: {
            if (this.cred.getRemainingLifetime() < 60) {
                throw new Exception("Remaining lifetime of credential is less than a minute.");
            }
            try {
                SrmStatusOfLsRequestResponse statusResponse;
                TReturnStatus status;
                SrmLsRequest req = new SrmLsRequest();
                req.setAllLevelRecursive(Boolean.FALSE);
                req.setFullDetailedList(this.configuration.isLongLsFormat());
                req.setNumOfLevels(new Integer(this.configuration.getRecursionDepth()));
                req.setOffset(new Integer(this.configuration.getLsOffset()));
                if (this.configuration.getLsCount() != null) {
                    req.setCount(this.configuration.getLsCount());
                }
                URI[] turlia = new URI[this.surls.length];
                for (int i = 0; i < this.surls.length; ++i) {
                    turlia[i] = new URI(this.surl_strings[i]);
                }
                req.setArrayOfSURLs(new ArrayOfAnyURI(turlia));
                this.hook = new Thread(this);
                Runtime.getRuntime().addShutdownHook(this.hook);
                SrmLsResponse response = this.isrm.srmLs(req);
                if (response == null) {
                    throw new Exception("srm ls response is null!");
                }
                TReturnStatus rs = response.getReturnStatus();
                this.requestToken = response.getRequestToken();
                if (rs == null) {
                    throw new IOException(" null TReturnStatus ");
                }
                StringBuffer sb = new StringBuffer();
                String statusText = "Return status:\n - Status code:  " + response.getReturnStatus().getStatusCode().getValue() + '\n' + " - Explanation:  " + response.getReturnStatus().getExplanation();
                this.logger.log(statusText.toString());
                if (RequestStatusTool.isFailedRequestStatus(rs)) {
                    sb.append(statusText + '\n');
                }
                if (!RequestStatusTool.isTransientStateStatus(rs)) {
                    if (response.getDetails() == null) {
                        throw new IOException(sb.toString() + "srm ls response path details array is null!");
                    }
                    if (response.getDetails().getPathDetailArray() != null) {
                        TMetaDataPathDetail[] details = response.getDetails().getPathDetailArray();
                        SRMLsClientV2.printResults(sb, details, 0, " ", this.configuration.isLongLsFormat());
                    }
                    if (RequestStatusTool.isFailedRequestStatus(rs)) {
                        throw new IOException(sb.toString());
                    }
                    System.out.println(sb.toString());
                    break block36;
                }
                if (this.requestToken == null) {
                    throw new IOException("Request is queued on the server, however the server did not provide a request token.");
                }
                if (RequestStatusTool.isFailedRequestStatus(rs)) {
                    throw new IOException(sb.toString());
                }
                SrmStatusOfLsRequestRequest statusRequest = new SrmStatusOfLsRequestRequest();
                statusRequest.setRequestToken(this.requestToken);
                statusRequest.setOffset(req.getOffset());
                statusRequest.setCount(req.getCount());
                statusRequest.setAuthorizationID(req.getAuthorizationID());
                long estimatedWaitInSeconds = 2L;
                do {
                    if (estimatedWaitInSeconds > 60L) {
                        estimatedWaitInSeconds = 60L;
                    }
                    try {
                        this.say("sleeping " + estimatedWaitInSeconds + " seconds ...");
                        Thread.sleep(estimatedWaitInSeconds * 1000L);
                    }
                    catch (InterruptedException ie) {
                        this.esay("Interrupted, quitting");
                        if (this.requestToken != null) {
                            this.abortRequest();
                        }
                        System.exit(1);
                    }
                    estimatedWaitInSeconds *= 2L;
                    statusResponse = this.isrm.srmStatusOfLsRequest(statusRequest);
                    if (statusResponse == null) {
                        throw new IOException("SrmStatusOfLsRequestResponse is null for request " + this.requestToken);
                    }
                    status = statusResponse.getReturnStatus();
                    if (status == null) {
                        throw new IOException(" null return status");
                    }
                    if (status.getStatusCode() != null) continue;
                    throw new IOException(" null status code");
                } while (RequestStatusTool.isTransientStateStatus(status));
                statusText = "Return status:\n - Status code:  " + status.getStatusCode().getValue() + '\n' + " - Explanation:  " + status.getExplanation() + '\n' + " - request token: " + this.requestToken;
                this.logger.log(statusText.toString());
                if (RequestStatusTool.isFailedRequestStatus(status)) {
                    sb.append(statusText + '\n');
                }
                if (statusResponse.getDetails() == null) {
                    throw new IOException(sb.toString() + "srm ls response path details array is null!");
                }
                if (statusResponse.getDetails().getPathDetailArray() != null) {
                    TMetaDataPathDetail[] details = statusResponse.getDetails().getPathDetailArray();
                    SRMLsClientV2.printResults(sb, details, 0, " ", this.configuration.isLongLsFormat());
                    if (RequestStatusTool.isFailedRequestStatus(status)) {
                        throw new IOException(sb.toString());
                    }
                    System.out.println(sb.toString());
                }
            }
            catch (Exception e) {
                this.esay(e.getMessage());
                try {
                    if (this.requestToken != null) {
                        this.abortRequest();
                    }
                }
                catch (Exception e1) {
                    this.logger.elog(e1.toString());
                }
                finally {
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    System.exit(1);
                }
            }
            finally {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.say("stopping ");
            if (this.requestToken != null) {
                this.abortRequest();
            }
        }
        catch (Exception e) {
            this.logger.elog(e.toString());
        }
    }

    public void abortRequest() throws Exception {
        SrmAbortRequestRequest abortRequest = new SrmAbortRequestRequest();
        abortRequest.setRequestToken(this.requestToken);
        SrmAbortRequestResponse abortResponse = this.isrm.srmAbortRequest(abortRequest);
        if (abortResponse == null) {
            this.logger.elog(" SrmAbort is null");
        } else {
            TReturnStatus returnStatus = abortResponse.getReturnStatus();
            if (returnStatus == null) {
                this.esay("srmAbort return status is null");
                return;
            }
            this.say("srmAbortRequest status code=" + returnStatus.getStatusCode());
        }
    }

    public URI getTSURLInfo(String surl) throws Exception {
        URI uri = new URI(surl);
        return uri;
    }

    public static void printResults(StringBuffer sb, TMetaDataPathDetail[] ta, int depth, String depthPrefix, boolean longFormat) {
        if (ta != null) {
            for (int i = 0; i < ta.length; ++i) {
                TMetaDataPathDetail metaDataPathDetail = ta[i];
                if (metaDataPathDetail == null) continue;
                if (metaDataPathDetail.getStatus().getStatusCode() == TStatusCode.fromString("SRM_INVALID_PATH")) {
                    sb.append("SRM_INVALID_PATH").append(" ").append(depthPrefix).append(" File/directory " + i + " " + metaDataPathDetail.getPath() + " does not exist. \n");
                    continue;
                }
                sb.append(depthPrefix);
                UnsignedLong size = metaDataPathDetail.getSize();
                if (size != null) {
                    sb.append(" ").append(size.longValue());
                }
                sb.append(" ").append(metaDataPathDetail.getPath());
                if (metaDataPathDetail.getType() == TFileType.DIRECTORY) {
                    sb.append("/");
                }
                if (metaDataPathDetail.getStatus().getStatusCode() != TStatusCode.SRM_SUCCESS) {
                    sb.append(" (" + metaDataPathDetail.getStatus().getStatusCode() + "," + metaDataPathDetail.getStatus().getExplanation() + ")");
                }
                sb.append('\n');
                if (longFormat) {
                    StringBuffer dsb;
                    Date tdate;
                    sb.append(" space token(s) :");
                    if (metaDataPathDetail.getArrayOfSpaceTokens() != null) {
                        for (int j = 0; j < metaDataPathDetail.getArrayOfSpaceTokens().getStringArray().length; ++j) {
                            if (j == metaDataPathDetail.getArrayOfSpaceTokens().getStringArray().length - 1) {
                                sb.append(metaDataPathDetail.getArrayOfSpaceTokens().getStringArray()[j]);
                                continue;
                            }
                            sb.append(metaDataPathDetail.getArrayOfSpaceTokens().getStringArray()[j] + ",");
                        }
                    } else {
                        sb.append("none found");
                    }
                    sb.append('\n');
                    TFileStorageType stortype = metaDataPathDetail.getFileStorageType();
                    if (stortype != null) {
                        sb.append(depthPrefix);
                        sb.append(" storage type:").append(stortype.getValue());
                        sb.append('\n');
                    } else {
                        sb.append(" type: null");
                        sb.append('\n');
                    }
                    TRetentionPolicyInfo rpi = metaDataPathDetail.getRetentionPolicyInfo();
                    if (rpi != null) {
                        TRetentionPolicy rt = rpi.getRetentionPolicy();
                        if (rt != null) {
                            sb.append(depthPrefix);
                            sb.append(" retention policy:").append(rt.getValue());
                            sb.append('\n');
                        } else {
                            sb.append(" retention policy: null");
                            sb.append('\n');
                        }
                        TAccessLatency al = rpi.getAccessLatency();
                        if (al != null) {
                            sb.append(depthPrefix);
                            sb.append(" access latency:").append(al.getValue());
                            sb.append('\n');
                        } else {
                            sb.append(" access latency: null");
                            sb.append('\n');
                        }
                    } else {
                        sb.append(" retentionpolicyinfo : null");
                        sb.append('\n');
                    }
                    TFileLocality locality = metaDataPathDetail.getFileLocality();
                    if (locality != null) {
                        sb.append(depthPrefix);
                        sb.append(" locality:").append(locality.getValue());
                        sb.append('\n');
                    } else {
                        sb.append(" locality: null");
                        sb.append('\n');
                    }
                    if (metaDataPathDetail.getCheckSumValue() != null) {
                        sb.append(depthPrefix).append(" - Checksum value:  " + metaDataPathDetail.getCheckSumValue() + '\n');
                    }
                    if (metaDataPathDetail.getCheckSumType() != null) {
                        sb.append(depthPrefix).append(" - Checksum type:  " + metaDataPathDetail.getCheckSumType() + '\n');
                    }
                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    FieldPosition tfp = new FieldPosition(0);
                    if (metaDataPathDetail.getOwnerPermission() != null) {
                        TUserPermission up = metaDataPathDetail.getOwnerPermission();
                        sb.append(depthPrefix).append("  UserPermission:");
                        sb.append(" uid=").append(up.getUserID());
                        sb.append(" Permissions");
                        sb.append(up.getMode().getValue());
                        sb.append('\n');
                    }
                    if (metaDataPathDetail.getGroupPermission() != null) {
                        TGroupPermission gp = metaDataPathDetail.getGroupPermission();
                        sb.append(depthPrefix).append("  GroupPermission:");
                        sb.append(" gid=").append(gp.getGroupID());
                        sb.append(" Permissions");
                        sb.append(gp.getMode().getValue());
                        sb.append('\n');
                    }
                    if (metaDataPathDetail.getOtherPermission() != null) {
                        sb.append(depthPrefix).append(" WorldPermission: ");
                        sb.append(metaDataPathDetail.getOtherPermission().getValue());
                        sb.append('\n');
                    }
                    if (metaDataPathDetail.getCreatedAtTime() != null && (tdate = metaDataPathDetail.getCreatedAtTime().getTime()) != null) {
                        dsb = new StringBuffer();
                        df.format(tdate, dsb, tfp);
                        sb.append(depthPrefix).append("created at:").append(dsb);
                        sb.append('\n');
                    }
                    if (metaDataPathDetail.getLastModificationTime() != null && (tdate = metaDataPathDetail.getLastModificationTime().getTime()) != null) {
                        dsb = new StringBuffer();
                        df.format(tdate, dsb, tfp);
                        sb.append(depthPrefix);
                        sb.append("modified at:").append(dsb);
                        sb.append('\n');
                    }
                    if (metaDataPathDetail.getLifetimeAssigned() != null) {
                        sb.append(depthPrefix).append("  - Assigned lifetime (in seconds):  " + metaDataPathDetail.getLifetimeAssigned() + '\n');
                    }
                    if (metaDataPathDetail.getLifetimeLeft() != null) {
                        sb.append(depthPrefix).append(" - Lifetime left (in seconds):  " + metaDataPathDetail.getLifetimeLeft() + '\n');
                    }
                    sb.append(depthPrefix).append(" - Original SURL:  " + metaDataPathDetail.getPath() + '\n' + " - Status:  " + metaDataPathDetail.getStatus().getExplanation() + '\n' + " - Type:  " + metaDataPathDetail.getType() + '\n');
                }
                if (metaDataPathDetail.getArrayOfSubPaths() == null) continue;
                TMetaDataPathDetail[] subpaths = metaDataPathDetail.getArrayOfSubPaths().getPathDetailArray();
                if (subpaths == ta) {
                    sb.append(depthPrefix).append(" circular subpath reference !!!");
                    continue;
                }
                SRMLsClientV2.printResults(sb, subpaths, depth + 1, depthPrefix + "    ", longFormat);
            }
        }
    }
}

