/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmGetSpaceTokensRequest;
import org.dcache.srm.v2_2.SrmGetSpaceTokensResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMGetSpaceTokensClientV2
extends SRMClient {
    private GlobusURL srmURL;
    private GSSCredential credential = null;
    private ISRM srmv2;

    public SRMGetSpaceTokensClientV2(Configuration configuration, GlobusURL url) {
        super(configuration);
        this.srmURL = url;
        try {
            this.credential = this.getGssCredential();
        }
        catch (Exception e) {
            this.credential = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        this.srmv2 = new SRMClientV2(this.srmURL, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        String tokenDescription = this.configuration.getSpaceTokenDescription();
        SrmGetSpaceTokensRequest request = new SrmGetSpaceTokensRequest();
        request.setUserSpaceTokenDescription(tokenDescription);
        SrmGetSpaceTokensResponse response = this.srmv2.srmGetSpaceTokens(request);
        if (response == null) {
            throw new IOException(" null SrmGetSpaceTokensResponse");
        }
        TReturnStatus rs = response.getReturnStatus();
        if (rs == null) {
            throw new IOException(" null TReturnStatus ");
        }
        if (RequestStatusTool.isFailedRequestStatus(rs)) {
            throw new IOException("SrmGetSpaceTokens failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
        }
        if (response.getArrayOfSpaceTokens() == null || response.getArrayOfSpaceTokens().getStringArray() == null) {
            throw new IOException("SrmGetSpaceTokens returned null array of space tokens");
        }
        String[] spaceTokens = response.getArrayOfSpaceTokens().getStringArray();
        System.out.println("Space Reservation Tokens:");
        for (int i = 0; i < spaceTokens.length; ++i) {
            System.out.println(spaceTokens[i]);
        }
    }
}

