/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmGetSpaceMetaDataRequest;
import org.dcache.srm.v2_2.SrmGetSpaceMetaDataResponse;
import org.dcache.srm.v2_2.TMetaDataSpace;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMGetSpaceMetaDataClientV2
extends SRMClient {
    private GlobusURL srmURL;
    private GSSCredential credential = null;
    private ISRM srmv2;

    public SRMGetSpaceMetaDataClientV2(Configuration configuration, GlobusURL url) {
        super(configuration);
        this.srmURL = url;
        try {
            this.credential = this.getGssCredential();
        }
        catch (Exception e) {
            this.credential = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        this.srmv2 = new SRMClientV2(this.srmURL, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        String[] tokens = this.configuration.getSpaceTokensList();
        SrmGetSpaceMetaDataRequest request = new SrmGetSpaceMetaDataRequest();
        request.setArrayOfSpaceTokens(new ArrayOfString(tokens));
        SrmGetSpaceMetaDataResponse response = this.srmv2.srmGetSpaceMetaData(request);
        if (response == null) {
            throw new IOException(" null SrmGetSpaceMetaDataResponse");
        }
        TReturnStatus rs = response.getReturnStatus();
        if (rs == null) {
            throw new IOException(" null TReturnStatus ");
        }
        if (RequestStatusTool.isFailedRequestStatus(rs)) {
            throw new IOException("SrmGetSpaceMetaData failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
        }
        TMetaDataSpace[] spaceMetaDatas = response.getArrayOfSpaceDetails().getSpaceDataArray();
        for (int i = 0; i < spaceMetaDatas.length; ++i) {
            TMetaDataSpace spaceMetaData = spaceMetaDatas[i];
            System.out.println("Space Reservation with token=" + spaceMetaData.getSpaceToken());
            if (spaceMetaData.getStatus().getStatusCode() != TStatusCode.SRM_SUCCESS) {
                System.out.println("\t StatusCode=" + spaceMetaData.getStatus().getStatusCode() + " explanation=" + spaceMetaData.getStatus().getExplanation());
                continue;
            }
            System.out.println("\t           owner:" + spaceMetaData.getOwner());
            System.out.println("\t       totalSize:" + spaceMetaData.getTotalSize());
            System.out.println("\t  guaranteedSize:" + spaceMetaData.getGuaranteedSize());
            System.out.println("\t      unusedSize:" + spaceMetaData.getUnusedSize());
            System.out.println("\tlifetimeAssigned:" + spaceMetaData.getLifetimeAssigned());
            System.out.println("\t    lifetimeLeft:" + spaceMetaData.getLifetimeLeft());
            TRetentionPolicyInfo policyInfo = spaceMetaData.getRetentionPolicyInfo();
            if (policyInfo == null) continue;
            System.out.println("\t   accessLatency:" + policyInfo.getAccessLatency());
            System.out.println("\t retentionPolicy:" + policyInfo.getRetentionPolicy());
        }
    }
}

