/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfTGroupPermission;
import org.dcache.srm.v2_2.ArrayOfTPermissionReturn;
import org.dcache.srm.v2_2.ArrayOfTUserPermission;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmGetPermissionRequest;
import org.dcache.srm.v2_2.SrmGetPermissionResponse;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TPermissionReturn;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TUserPermission;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMGetPermissionClientV2
extends SRMClient {
    private GSSCredential cred = null;
    private GlobusURL[] surls;
    private String[] surl_string;
    private ISRM isrm;

    public SRMGetPermissionClientV2(Configuration configuration, GlobusURL[] surls, String[] surl_string) {
        super(configuration);
        this.surls = surls;
        this.surl_string = surl_string;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surls[0];
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        ArrayOfAnyURI surlarray = new ArrayOfAnyURI();
        URI[] uriarray = new URI[this.surl_string.length];
        for (int i = 0; i < uriarray.length; ++i) {
            URI uri;
            uriarray[i] = uri = new URI(this.surl_string[i]);
        }
        surlarray.setUrlArray(uriarray);
        SrmGetPermissionRequest req = new SrmGetPermissionRequest();
        req.setArrayOfSURLs(surlarray);
        SrmGetPermissionResponse resp = this.isrm.srmGetPermission(req);
        TReturnStatus rs = resp.getReturnStatus();
        ArrayOfTPermissionReturn permissions = resp.getArrayOfPermissionReturns();
        TPermissionReturn[] permissionarray = null;
        if (permissions != null) {
            permissionarray = permissions.getPermissionArray();
        }
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            TStatusCode rc = rs.getStatusCode();
            StringBuffer sb = new StringBuffer();
            sb.append("Return code: " + rc.toString() + "\n");
            sb.append("Explanation: " + rs.getExplanation() + "\n");
            System.out.println(sb.toString());
        }
        StringBuffer txt = new StringBuffer();
        if (permissionarray == null) {
            txt.append("permissions array is null\n");
            System.out.println(txt.toString());
            System.exit(1);
        }
        for (int i = 0; i < permissionarray.length; ++i) {
            TGroupPermission[] groupPermissionArray;
            ArrayOfTGroupPermission arrayOfGroupPermissions;
            TUserPermission[] userPermissionArray;
            txt.append("# file  : " + permissionarray[i].getSurl() + "\n");
            if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
                txt.append("Return code: " + permissionarray[i].getStatus().getStatusCode().toString() + "\n");
                txt.append("Explanation: " + permissionarray[i].getStatus().getExplanation() + "\n");
                if (permissionarray[i].getStatus().getStatusCode() != TStatusCode.SRM_SUCCESS) continue;
            }
            TPermissionReturn pr = permissionarray[i];
            txt.append("# owner : " + pr.getOwner() + "\n");
            txt.append("owner:" + pr.getOwner() + ":" + pr.getOwnerPermission().toString() + "\n");
            ArrayOfTUserPermission arrayOfUserPermissions = pr.getArrayOfUserPermissions();
            if (arrayOfUserPermissions != null && (userPermissionArray = arrayOfUserPermissions.getUserPermissionArray()) != null) {
                for (TUserPermission upr : userPermissionArray) {
                    if (upr == null) continue;
                    txt.append("user:" + upr.getUserID() + ":" + upr.getMode().toString() + "\n");
                }
            }
            if ((arrayOfGroupPermissions = pr.getArrayOfGroupPermissions()) != null && (groupPermissionArray = arrayOfGroupPermissions.getGroupPermissionArray()) != null) {
                for (TGroupPermission upr : groupPermissionArray) {
                    if (upr == null) continue;
                    txt.append("group:" + upr.getGroupID() + ":" + upr.getMode().toString() + "\n");
                }
            }
            txt.append("other:" + pr.getOtherPermission().toString() + "\n");
        }
        System.out.println(txt.toString());
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

