/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Copier;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import gov.fnal.srm.util.SRMV2CopyJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.request.AccessLatency;
import org.dcache.srm.request.RetentionPolicy;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ArrayOfTGetFileRequest;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmPrepareToGetRequest;
import org.dcache.srm.v2_2.SrmPrepareToGetResponse;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TGetFileRequest;
import org.dcache.srm.v2_2.TGetRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.globus.util.GlobusURL;

public class SRMGetClientV2
extends SRMClient
implements Runnable {
    private String[] protocols;
    GlobusURL[] from;
    GlobusURL[] to;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    private Copier copier;
    private String requestToken;
    private Thread hook;
    private ISRM srmv2;

    public SRMGetClientV2(Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
        this.to = to;
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.from[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    @Override
    public void start() throws Exception {
        try {
            TAccessLatency al;
            this.copier = new Copier(this.urlcopy, this.configuration);
            this.copier.setDebug(this.debug);
            new Thread(this.copier).start();
            int len = this.from.length;
            String[] SURLS = new String[len];
            TGetFileRequest[] fileRequests = new TGetFileRequest[len];
            for (int i = 0; i < len; ++i) {
                SURLS[i] = this.from[i].getURL();
                URI uri = new URI(SURLS[i]);
                fileRequests[i] = new TGetFileRequest();
                fileRequests[i].setSourceSURL(uri);
                this.pendingSurlsToIndex.put(SURLS[i], new Integer(i));
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            SrmPrepareToGetRequest srmPrepareToGetRequest = new SrmPrepareToGetRequest();
            srmPrepareToGetRequest.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
            TRetentionPolicy rp = this.configuration.getRetentionPolicy() != null ? RetentionPolicy.fromString(this.configuration.getRetentionPolicy()).toTRetentionPolicy() : null;
            TAccessLatency tAccessLatency = al = this.configuration.getAccessLatency() != null ? AccessLatency.fromString(this.configuration.getAccessLatency()).toTAccessLatency() : null;
            if (al != null && rp == null) {
                throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
            }
            if (rp != null) {
                srmPrepareToGetRequest.setTargetFileRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
            }
            srmPrepareToGetRequest.setArrayOfFileRequests(new ArrayOfTGetFileRequest(fileRequests));
            TAccessPattern ap = null;
            if (this.configuration.getAccessPattern() != null) {
                ap = TAccessPattern.fromString(this.configuration.getAccessPattern());
            }
            TConnectionType ct = null;
            if (this.configuration.getConnectionType() != null) {
                ct = TConnectionType.fromString(this.configuration.getConnectionType());
            }
            ArrayOfString protocolArray = null;
            if (this.protocols != null) {
                protocolArray = new ArrayOfString(this.protocols);
            }
            ArrayOfString arrayOfClientNetworks = null;
            if (this.configuration.getArrayOfClientNetworks() != null) {
                arrayOfClientNetworks = new ArrayOfString(this.configuration.getArrayOfClientNetworks());
            }
            if (ap != null || ct != null || arrayOfClientNetworks != null || protocolArray != null) {
                srmPrepareToGetRequest.setTransferParameters(new TTransferParameters(ap, ct, arrayOfClientNetworks, protocolArray));
            }
            if (this.configuration.getExtraParameters().size() > 0) {
                TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                int counter = 0;
                Map<String, String> extraParameters = this.configuration.getExtraParameters();
                for (String key : extraParameters.keySet()) {
                    String value = extraParameters.get(key);
                    extraInfoArray[counter++] = new TExtraInfo(key, value);
                }
                ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                srmPrepareToGetRequest.setStorageSystemInfo(arrayOfExtraInfo);
            }
            this.say("calling srmPrepareToGet");
            SrmPrepareToGetResponse response = this.srmv2.srmPrepareToGet(srmPrepareToGetRequest);
            this.say("received response");
            if (response == null) {
                throw new IOException(" null response");
            }
            TReturnStatus status = response.getReturnStatus();
            if (status == null) {
                throw new IOException(" null return status");
            }
            TStatusCode statusCode = status.getStatusCode();
            if (statusCode == null) {
                throw new IOException(" null status code");
            }
            if (RequestStatusTool.isFailedRequestStatus(status)) {
                throw new IOException("srmPrepareToGet submission failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
            }
            this.requestToken = response.getRequestToken();
            this.dsay(" srm returned requestToken = " + this.requestToken);
            if (response.getArrayOfFileStatuses() == null) {
                throw new IOException("returned GetRequestFileStatuses is an empty array");
            }
            TGetRequestFileStatus[] getRequestFileStatuses = response.getArrayOfFileStatuses().getStatusArray();
            if (getRequestFileStatuses.length != len) {
                throw new IOException("incorrect number of GetRequestFileStatusesin RequestStatus expected " + len + " received " + getRequestFileStatuses.length);
            }
            while (!this.pendingSurlsToIndex.isEmpty()) {
                String error;
                long estimatedWaitInSeconds = 5L;
                for (int i = 0; i < len; ++i) {
                    int indx;
                    TGetRequestFileStatus getRequestFileStatus = getRequestFileStatuses[i];
                    URI surl = getRequestFileStatus.getSourceSURL();
                    if (surl == null) {
                        this.esay("invalid getRequestFileStatus, surl is null");
                        continue;
                    }
                    String surl_string = surl.toString();
                    if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                        this.esay("invalid getRequestFileStatus, surl = " + surl_string + " not found");
                        continue;
                    }
                    TReturnStatus fileStatus = getRequestFileStatus.getStatus();
                    if (fileStatus == null) {
                        throw new IOException(" null file return status");
                    }
                    TStatusCode fileStatusCode = fileStatus.getStatusCode();
                    if (fileStatusCode == null) {
                        throw new IOException(" null file status code");
                    }
                    if (RequestStatusTool.isFailedFileRequestStatus(fileStatus)) {
                        String error2 = "retreval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                        this.esay(error2);
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.setReportFailed(this.from[indx], this.to[indx], error2);
                        continue;
                    }
                    if (getRequestFileStatus.getTransferURL() != null) {
                        GlobusURL globusTURL = new GlobusURL(getRequestFileStatus.getTransferURL().toString());
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.setReportFailed(this.from[indx], this.to[indx], "received TURL, but did not complete transfer");
                        SRMV2CopyJob job = new SRMV2CopyJob(globusTURL, this.to[indx], this.srmv2, this.requestToken, this.logger, this.from[indx], true, this);
                        this.copier.addCopyJob(job);
                        continue;
                    }
                    if (getRequestFileStatus.getEstimatedWaitTime() == null || (long)getRequestFileStatus.getEstimatedWaitTime().intValue() >= estimatedWaitInSeconds || getRequestFileStatus.getEstimatedWaitTime() < 1) continue;
                    estimatedWaitInSeconds = getRequestFileStatus.getEstimatedWaitTime().intValue();
                }
                if (this.pendingSurlsToIndex.isEmpty()) {
                    this.dsay("no more pending transfers, breaking the loop");
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    break;
                }
                if (estimatedWaitInSeconds > 60L) {
                    estimatedWaitInSeconds = 60L;
                }
                try {
                    this.say("sleeping " + estimatedWaitInSeconds + " seconds ...");
                    Thread.sleep(estimatedWaitInSeconds * 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                SrmStatusOfGetRequestRequest srmStatusOfGetRequestRequest = new SrmStatusOfGetRequestRequest();
                srmStatusOfGetRequestRequest.setRequestToken(this.requestToken);
                String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                int expectedResponseLength = pendingSurlStrings.length;
                URI[] surlArray = new URI[expectedResponseLength];
                for (int i = 0; i < expectedResponseLength; ++i) {
                    surlArray[i] = new URI(pendingSurlStrings[i]);
                }
                srmStatusOfGetRequestRequest.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArray));
                SrmStatusOfGetRequestResponse srmStatusOfGetRequestResponse = this.srmv2.srmStatusOfGetRequest(srmStatusOfGetRequestRequest);
                if (srmStatusOfGetRequestResponse == null) {
                    throw new IOException(" null srmStatusOfGetRequestResponse");
                }
                if (srmStatusOfGetRequestResponse.getArrayOfFileStatuses() == null) {
                    error = "array of RequestFileStatuses is null ";
                    statusCode = status.getStatusCode();
                    if (statusCode != null) {
                        error = error + " status : " + statusCode + " explanation=" + status.getExplanation();
                    }
                    this.esay(error);
                    throw new IOException(error);
                }
                getRequestFileStatuses = srmStatusOfGetRequestResponse.getArrayOfFileStatuses().getStatusArray();
                if (getRequestFileStatuses == null || getRequestFileStatuses.length != expectedResponseLength) {
                    error = "incorrect number of RequestFileStatuses";
                    statusCode = status.getStatusCode();
                    if (statusCode != null) {
                        error = error + " status : " + statusCode + " explanation=" + status.getExplanation();
                    }
                    this.esay(error);
                    throw new IOException(error);
                }
                status = srmStatusOfGetRequestResponse.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (!RequestStatusTool.isFailedRequestStatus(status)) continue;
                error = "srmPrepareToGet update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                this.esay(error);
                for (int i = 0; i < expectedResponseLength; ++i) {
                    TReturnStatus frstatus = getRequestFileStatuses[i].getStatus();
                    if (frstatus == null) continue;
                    this.esay("GetFileRequest[" + getRequestFileStatuses[i].getSourceSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                    if (RequestStatusTool.isTransientStateStatus(frstatus)) continue;
                    this.pendingSurlsToIndex.remove(getRequestFileStatuses[i].getSourceSURL().toString());
                }
                throw new IOException(error);
            }
        }
        catch (Exception e) {
            try {
                if (this.copier != null) {
                    this.dsay("stopping copier");
                    this.copier.stop();
                    this.abortAllPendingFiles();
                }
            }
            catch (Exception e1) {
                this.edsay(e1.toString());
            }
            throw e;
        }
        finally {
            if (this.copier != null) {
                this.copier.doneAddingJobs();
                try {
                    this.copier.waitCompletion();
                }
                catch (Exception e1) {
                    this.edsay(e1.toString());
                }
            }
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm copy of at least one file failed or not completed");
            }
        }
    }

    @Override
    public void run() {
        try {
            this.dsay("stopping copier");
            this.copier.stop();
            this.abortAllPendingFiles();
        }
        catch (Exception e) {
            this.logger.elog(e.toString());
        }
    }

    private void abortAllPendingFiles() throws Exception {
        if (this.pendingSurlsToIndex.isEmpty()) {
            return;
        }
        if (this.requestToken != null) {
            String[] surl_strings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
            int len = surl_strings.length;
            this.say("Releasing all remaining file requests");
            URI[] surlArray = new URI[len];
            for (int i = 0; i < len; ++i) {
                surlArray[i] = new URI(surl_strings[i]);
            }
            SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
            srmAbortFilesRequest.setRequestToken(this.requestToken);
            srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
            SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
            if (srmAbortFilesResponse == null) {
                this.logger.elog(" srmAbortFilesResponse is null");
            } else {
                TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                if (returnStatus == null) {
                    this.esay("srmAbortFiles return status is null");
                    return;
                }
                this.say("srmAbortFiles status code=" + returnStatus.getStatusCode());
            }
        }
    }
}

