/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeRequest;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLLifetimeReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMExtendFileLifeTimeClientV2
extends SRMClient {
    private GSSCredential cred = null;
    private GlobusURL[] surls;
    private String[] surl_strings;
    private ISRM isrm;

    public SRMExtendFileLifeTimeClientV2(Configuration configuration, GlobusURL[] surls, String[] surl_strings) {
        super(configuration);
        this.surls = surls;
        this.surl_strings = surl_strings;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            this.esay("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surls[0];
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        ArrayOfAnyURI surlarray = new ArrayOfAnyURI();
        URI[] uriarray = new URI[this.surls.length];
        for (int i = 0; i < uriarray.length; ++i) {
            URI uri;
            uriarray[i] = uri = new URI(this.surl_strings[i]);
        }
        surlarray.setUrlArray(uriarray);
        SrmExtendFileLifeTimeRequest req = new SrmExtendFileLifeTimeRequest();
        req.setArrayOfSURLs(surlarray);
        req.setRequestToken(this.configuration.getExtendFileLifetimeRequestToken());
        req.setNewFileLifeTime(this.configuration.getNewFileLifetime());
        req.setNewPinLifeTime(this.configuration.getNewPinLifetime());
        SrmExtendFileLifeTimeResponse resp = this.isrm.srmExtendFileLifeTime(req);
        if (resp == null) {
            this.esay("Received null SrmExtendFileLifeTimeResponse");
            System.exit(1);
        }
        try {
            TReturnStatus rs = resp.getReturnStatus();
            if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS || this.configuration.isDebug()) {
                TStatusCode rc = rs.getStatusCode();
                StringBuffer sb = new StringBuffer();
                sb.append("Return code: " + rc.toString() + "\n");
                sb.append("Explanation: " + rs.getExplanation() + "\n");
                if (resp.getArrayOfFileStatuses() != null) {
                    if (resp.getArrayOfFileStatuses().getStatusArray() != null) {
                        for (int i = 0; i < resp.getArrayOfFileStatuses().getStatusArray().length; ++i) {
                            TSURLLifetimeReturnStatus t = resp.getArrayOfFileStatuses().getStatusArray()[i];
                            sb.append("surl[" + i + "] " + t.getSurl() + "\n");
                            sb.append("\tReturn code: " + t.getStatus().getStatusCode().toString() + "\n");
                            sb.append("\tExplanation: " + t.getStatus().getExplanation() + "\n");
                            sb.append("\t\tfilelifetime=" + t.getFileLifetime() + "\n");
                            sb.append("\t\tpinlifetime=" + t.getPinLifetime() + "\n");
                        }
                    } else {
                        sb.append("array of file statuse is null\n");
                    }
                } else {
                    sb.append("array of file statuse is null\n");
                }
                if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
                    this.esay(sb.toString());
                    System.exit(1);
                } else {
                    this.say(sb.toString());
                }
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

