/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortRequestRequest;
import org.dcache.srm.v2_2.SrmAbortRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMAbortRequestClientV2
extends SRMClient {
    private ISRM isrm;
    private GlobusURL srmURL;
    private GSSCredential credential = null;

    public SRMAbortRequestClientV2(Configuration configuration, GlobusURL url) {
        super(configuration);
        this.srmURL = url;
    }

    @Override
    public void connect() throws Exception {
        this.credential = this.getGssCredential();
        this.isrm = new SRMClientV2(this.srmURL, this.credential, this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        for (String requestToken : this.configuration.getArrayOfRequestTokens()) {
            SrmAbortRequestRequest request = new SrmAbortRequestRequest();
            request.setRequestToken(requestToken);
            SrmAbortRequestResponse response = this.isrm.srmAbortRequest(request);
            if (response == null) {
                throw new IOException(" null SrmAbortRequestResponse for request token " + requestToken);
            }
            TReturnStatus rs = response.getReturnStatus();
            if (rs == null) {
                throw new IOException(" null TReturnStatus for request token " + requestToken);
            }
            if (!RequestStatusTool.isFailedRequestStatus(rs)) continue;
            throw new IOException("SrmAbortRequest failed for " + requestToken + ",  : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
        }
    }
}

