/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMAbortFilesClientV2
extends SRMClient {
    private ISRM isrm;
    private GSSCredential credential = null;

    public SRMAbortFilesClientV2(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void connect() throws Exception {
        this.credential = this.getGssCredential();
        this.isrm = new SRMClientV2(new GlobusURL(this.configuration.getSrmUrl()), this.credential, this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        StringBuffer sb = new StringBuffer();
        boolean failed = false;
        if (this.configuration.getArrayOfRequestTokens() != null) {
            for (String requestToken : this.configuration.getArrayOfRequestTokens()) {
                SrmAbortFilesRequest request = new SrmAbortFilesRequest();
                request.setRequestToken(requestToken);
                ArrayOfAnyURI arrayOfSURLs = new ArrayOfAnyURI();
                URI[] urlArray = new URI[]{new URI(new GlobusURL(this.configuration.getSrmUrl()).getURL())};
                arrayOfSURLs.setUrlArray(urlArray);
                request.setArrayOfSURLs(arrayOfSURLs);
                SrmAbortFilesResponse response = this.isrm.srmAbortFiles(request);
                if (response == null) {
                    throw new IOException(" null SrmAbortFilesRespinse for request token " + requestToken);
                }
                TReturnStatus rs = response.getReturnStatus();
                if (rs == null) {
                    throw new IOException(" null TReturnStatus for request token " + requestToken);
                }
                if (RequestStatusTool.isFailedRequestStatus(rs)) {
                    failed = true;
                    sb.append("SrmAbortFiles failed for request token " + requestToken + ":\n ");
                    sb.append("return status: " + rs.getStatusCode() + ", Explanation : " + rs.getExplanation() + "\n");
                }
                if (response.getArrayOfFileStatuses() != null) {
                    if (response.getArrayOfFileStatuses().getStatusArray() != null) {
                        if (response.getArrayOfFileStatuses().getStatusArray().length > 0) {
                            for (TSURLReturnStatus status : response.getArrayOfFileStatuses().getStatusArray()) {
                                TReturnStatus st = status.getStatus();
                                if (st == null) {
                                    sb.append(status.getSurl() + " TReturnStatus is null\n");
                                    continue;
                                }
                                sb.append(status.getSurl() + " return code " + st.getStatusCode() + ", Explanation " + st.getExplanation() + "\n");
                            }
                            continue;
                        }
                        sb.append("TSURLReturnStatus is empty\n");
                        continue;
                    }
                    sb.append("TSURLReturnStatus is null\n");
                    continue;
                }
                sb.append("getArrayOfFileStatuses is null");
            }
            if (failed) {
                throw new IOException(sb.toString());
            }
        } else if (this.configuration.getSurls() != null) {
            SrmAbortFilesRequest request = new SrmAbortFilesRequest();
            ArrayOfAnyURI arrayOfSURLs = new ArrayOfAnyURI();
            URI[] urlArray = new URI[this.configuration.getSurls().length];
            for (int i = 0; i < this.configuration.getSurls().length; ++i) {
                urlArray[i] = new URI(new GlobusURL(this.configuration.getSurls()[i]).getURL());
            }
            arrayOfSURLs.setUrlArray(urlArray);
            request.setArrayOfSURLs(arrayOfSURLs);
            SrmAbortFilesResponse response = this.isrm.srmAbortFiles(request);
            if (response == null) {
                throw new IOException(" null SrmAbortFilesResponse ");
            }
            TReturnStatus rs = response.getReturnStatus();
            if (rs == null) {
                throw new IOException(" null TReturnStatus ");
            }
            if (RequestStatusTool.isFailedRequestStatus(rs)) {
                sb.append("SrmAbortFiles failed:\n ");
                sb.append("return status: " + rs.getStatusCode() + ", Explanation : " + rs.getExplanation() + "\n");
            }
            if (response.getArrayOfFileStatuses() != null) {
                if (response.getArrayOfFileStatuses().getStatusArray() != null) {
                    if (response.getArrayOfFileStatuses().getStatusArray().length > 0) {
                        for (TSURLReturnStatus status : response.getArrayOfFileStatuses().getStatusArray()) {
                            TReturnStatus st = status.getStatus();
                            if (st == null) {
                                sb.append(status.getSurl() + " TReturnStatus is null\n");
                                continue;
                            }
                            sb.append(status.getSurl() + " return code " + st.getStatusCode() + ", Explanation " + st.getExplanation() + "\n");
                        }
                    } else {
                        sb.append("TSURLReturnStatus is empty\n");
                    }
                } else {
                    sb.append("TSURLReturnStatus is null\n");
                }
            } else {
                sb.append("getArrayOfFileStatuses is null");
            }
            if (RequestStatusTool.isFailedRequestStatus(rs)) {
                throw new IOException(sb.toString());
            }
        }
    }
}

