/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Args;
import gov.fnal.srm.util.Option;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class OptionParser {
    public static Set<String> getOptions(Object o) {
        HashSet<String> set = new HashSet<String>();
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                set.add(option.name());
            }
        }
        return set;
    }

    public static String getOption(Option option, Args args) throws IllegalArgumentException {
        return OptionParser.getOption(option, args, true);
    }

    public static String getOption(Option option, Args args, boolean setDefault) throws IllegalArgumentException {
        String s = null;
        s = args.getOpt(option.name());
        if (s != null) {
            if (s.length() == 0 && !option.required()) {
                return "true";
            }
            return s;
        }
        if (option.required()) {
            throw new IllegalArgumentException(option.name() + " is a required argument");
        }
        if (setDefault) {
            return option.defaultValue();
        }
        return s;
    }

    public static void checkOptions(Object o, Args args) {
        for (int i = 0; i < args.optc(); ++i) {
            String optionName = args.optv(i);
            Boolean exists = false;
            block1: for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    Option option = field.getAnnotation(Option.class);
                    if (option == null || !option.name().equals(optionName)) continue;
                    exists = true;
                    continue block1;
                }
            }
            if (exists.booleanValue()) continue;
            throw new IllegalArgumentException("Unknown option specified : -" + optionName);
        }
    }

    public static void checkNullOptions(Object o, String ... names) throws IllegalArgumentException {
        boolean haveNullOptions = false;
        StringBuilder sb = new StringBuilder();
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            block3: for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                for (String s : names) {
                    if (!option.name().equals(s)) continue;
                    try {
                        field.setAccessible(true);
                        Object value = field.get(o);
                        if (value != null) continue block3;
                        sb.append("   " + option.name() + " option must be set \n");
                        haveNullOptions = true;
                        continue block3;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                    }
                }
            }
        }
        if (haveNullOptions) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static String printOptions(Object o, String ... names) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        Class<?> c = o.getClass();
        int maxlength = 0;
        int nblanks = 3;
        for (String s : names) {
            if (s.length() <= maxlength) continue;
            maxlength = s.length();
        }
        int indent = maxlength + nblanks + 2;
        int width = 80 - indent;
        while (c != null) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                for (String s : names) {
                    if (!option.name().equals(s)) continue;
                    try {
                        int i;
                        String lines;
                        int i2;
                        field.setAccessible(true);
                        Object value = field.get(o);
                        for (i2 = 0; i2 < nblanks; ++i2) {
                            sb.append(' ');
                        }
                        sb.append("-" + option.name());
                        if (field.getType() != Boolean.TYPE) {
                            sb.append('=');
                        } else {
                            sb.append(' ');
                        }
                        for (i2 = option.name().length(); i2 < maxlength; ++i2) {
                            sb.append(' ');
                        }
                        if (field.getType() != Boolean.TYPE) {
                            lines = OptionParser.splitStringIntoSentences(option.description(), indent, width);
                            sb.append(lines).append('\n');
                            for (i = 0; i < indent; ++i) {
                                sb.append(' ');
                            }
                            sb.append("current value is " + (value != null ? value : "null(not set) ") + " " + option.unit() + "\n");
                            continue;
                        }
                        lines = OptionParser.splitStringIntoSentences(option.description() + "(switch)", indent, width);
                        sb.append(lines).append('\n');
                        for (i = 0; i < indent; ++i) {
                            sb.append(' ');
                        }
                        sb.append("current value is " + value + "\n");
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                    }
                }
            }
            c = c.getSuperclass();
        }
        return sb.toString();
    }

    public static <T> void setDefaults(T t) {
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                try {
                    field.setAccessible(true);
                    String s = option.defaultValue();
                    if (s == null || s.length() <= 0) continue;
                    try {
                        Object value = OptionParser.toType(s, field.getType());
                        field.set(t, value);
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Cannot convert '" + s + "' to " + field.getType(), e);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
    }

    public static <T> void parseOptions(T t, Args args) {
        OptionParser.checkOptions(t, args);
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                try {
                    field.setAccessible(true);
                    String s = OptionParser.getOption(option, args);
                    if (s == null || s.length() <= 0) continue;
                    try {
                        Object value = OptionParser.toType(s, field.getType());
                        field.set(t, value);
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Cannot convert '" + s + "' to " + field.getType(), e);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
    }

    public static <T> void parseSpecifiedOptions(T t, Args args) {
        OptionParser.checkOptions(t, args);
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                try {
                    field.setAccessible(true);
                    String s = OptionParser.getOption(option, args, false);
                    if (s == null || s.length() <= 0) continue;
                    try {
                        Object value = OptionParser.toType(s, field.getType());
                        field.set(t, value);
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Cannot convert '" + s + "' to " + field.getType(), e);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
    }

    public static <T> void parseOption(T t, String optionName, Args args) {
        boolean exists = false;
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null || !option.name().equals(optionName)) continue;
                exists = true;
                try {
                    field.setAccessible(true);
                    String s = OptionParser.getOption(option, args);
                    if (s == null || s.length() <= 0) continue;
                    try {
                        Object value = OptionParser.toType(s, field.getType());
                        field.set(t, value);
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Cannot convert '" + s + "' to " + field.getType(), e);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
        if (!exists) {
            throw new IllegalArgumentException("Unknown option specified : -" + optionName);
        }
    }

    protected <T> void writeOptions(T t, PrintWriter out) {
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                try {
                    if (!option.log()) continue;
                    field.setAccessible(true);
                    Object value = field.get(t);
                    String description = option.description();
                    String unit = option.unit();
                    if (description.length() == 0) {
                        description = option.name();
                    }
                    out.println(description + " is " + value + " " + unit);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
    }

    public static <T> T toType(Object object, Class<T> type) {
        T result = null;
        if (object == null || "null".equalsIgnoreCase(object.toString())) {
            if (type == Boolean.TYPE) {
                result = Boolean.class.cast(false);
            } else if (type == Byte.TYPE) {
                result = Byte.class.cast(0);
            } else if (type == Character.TYPE) {
                result = Character.class.cast(0);
            } else if (type == Double.TYPE) {
                result = Double.class.cast(0.0);
            } else if (type == Float.TYPE) {
                result = Float.class.cast(0.0);
            } else if (type == Integer.TYPE) {
                result = Integer.class.cast(0);
            } else if (type == Long.TYPE) {
                result = Long.class.cast(0);
            } else if (type == Short.TYPE) {
                result = Short.class.cast(0);
            }
        } else {
            String so = object.toString();
            if (type == BigInteger.class) {
                result = type.cast(new BigInteger(so));
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                Boolean r = null;
                r = "1".equals(so) || "true".equalsIgnoreCase(so) || "yes".equalsIgnoreCase(so) || "on".equalsIgnoreCase(so) || "enabled".equalsIgnoreCase(so) ? Boolean.TRUE : ("0".equals(object) || "false".equalsIgnoreCase(so) || "no".equalsIgnoreCase(so) || "off".equalsIgnoreCase(so) || "disabled".equalsIgnoreCase(so) ? Boolean.FALSE : Boolean.valueOf(so));
                result = type == Boolean.TYPE ? (T)Boolean.class.cast(r) : (T)type.cast(r);
            } else if (type == Byte.class || type == Byte.TYPE) {
                Byte i = Byte.valueOf(so);
                result = type == Byte.TYPE ? (T)Byte.class.cast(i) : (T)type.cast(i);
            } else if (type == Character.class || type == Character.TYPE) {
                Character i = new Character(so.charAt(0));
                result = type == Character.TYPE ? (T)Character.class.cast(i) : (T)type.cast(i);
            } else if (type == Double.class || type == Double.TYPE) {
                Double i = Double.valueOf(so);
                result = type == Double.TYPE ? (T)Double.class.cast(i) : (T)type.cast(i);
            } else if (type == Float.class || type == Float.TYPE) {
                Float i = Float.valueOf(so);
                result = type == Float.TYPE ? (T)Float.class.cast(i) : (T)type.cast(i);
            } else if (type == Integer.class || type == Integer.TYPE) {
                Integer i = Integer.valueOf(so);
                result = type == Integer.TYPE ? (T)Integer.class.cast(i) : (T)type.cast(i);
            } else if (type == Long.class || type == Long.TYPE) {
                Long i = Long.valueOf(so);
                result = type == Long.TYPE ? (T)Long.class.cast(i) : (T)type.cast(i);
            } else if (type == Short.class || type == Short.TYPE) {
                Short i = Short.valueOf(so);
                result = type == Short.TYPE ? (T)Short.class.cast(i) : (T)type.cast(i);
            } else {
                try {
                    Constructor<T> constructor = type.getConstructor(String.class);
                    result = constructor.newInstance(object);
                }
                catch (NoSuchMethodException e) {
                    result = type.cast(object);
                }
                catch (SecurityException e) {
                    result = type.cast(object);
                }
                catch (InstantiationException e) {
                    result = type.cast(object);
                }
                catch (IllegalAccessException e) {
                    result = type.cast(object);
                }
                catch (InvocationTargetException e) {
                    result = type.cast(object);
                }
            }
        }
        return result;
    }

    public static String splitStringIntoSentences(String text, int start, int width) {
        if (text.length() <= width) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        String[] words = text.split(" ");
        int currentLineWidth = 0;
        for (String word : words) {
            if ((currentLineWidth += word.length() + 1) > width - 1) {
                sb.append('\n');
                for (int j = 0; j < start; ++j) {
                    sb.append(' ');
                }
                currentLineWidth = 0;
            }
            sb.append(word).append(' ');
        }
        return sb.toString();
    }
}

