/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class Args
implements Serializable {
    static final long serialVersionUID = -8950082352156787965L;
    private final Hashtable<String, String> _optHash = new Hashtable();
    private final List<String> _optv = new Vector<String>();
    private final List<String> _argv = new Vector<String>();
    private String _oneChar = null;
    private static final int IDLE = 0;
    private static final int PLAIN_STRING = 1;
    private static final int QUOTED_STRING = 2;
    private static final int OPT_KEY = 3;
    private static final int OPT_VALUE = 4;
    private static final int OPT_QUOTED = 5;
    private static final int OPT_PLAIN = 6;
    private boolean _undo = false;
    private char _res = '\u0000';
    private int _current = 0;
    private String _line = null;
    private static final char END_OF_INFO = '\uffff';

    public Args(String args) {
        this.scanLine(args);
    }

    public Args(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        this.scanLine(sb.toString());
    }

    Args(Args in) {
        this._argv.addAll(in._argv);
        this._optv.addAll(in._optv);
        this._optHash.putAll(in._optHash);
        this._line = in._line;
    }

    public boolean isOneCharOption(char c) {
        return this._oneChar.indexOf(c) > -1;
    }

    public int argc() {
        return this._argv.size();
    }

    public int optc() {
        return this._optv.size();
    }

    public String getOpt(String optName) {
        return this._optHash.get(optName);
    }

    public String argv(int i) {
        String value = null;
        if (i < this._argv.size()) {
            value = this._argv.get(i);
        }
        return value;
    }

    public String optv(int i) {
        String value = null;
        if (i < this._optv.size()) {
            value = this._optv.get(i);
        }
        return value;
    }

    public void shift() {
        if (!this._argv.isEmpty()) {
            this._argv.remove(0);
        }
    }

    public Dictionary<String, String> options() {
        return this._optHash;
    }

    public Object clone() {
        return new Args(this);
    }

    public String toString() {
        return this._line;
    }

    public String getInfo() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Positional :\n");
        for (i = 0; i < this._argv.size(); ++i) {
            sb.append(i).append(" -> ").append(this._argv.get(i)).append("\n");
        }
        sb.append("Options :\n");
        for (i = 0; i < this._optv.size(); ++i) {
            String key = this._optv.get(i);
            String val = this._optHash.get(key);
            sb.append(key);
            if (val != null) {
                sb.append(" -> ").append(val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private char nextChar() {
        if (this._undo) {
            this._undo = false;
            return this._res;
        }
        return this._current >= this._line.length() ? (char)'\uffff' : this._line.charAt(this._current++);
    }

    private void scanLine(String line) {
        char c;
        this._line = line;
        int state = 0;
        StringBuilder key = null;
        StringBuilder value = null;
        StringBuilder oneChar = new StringBuilder();
        block9: do {
            c = this.nextChar();
            switch (state) {
                case 0: {
                    if (c == '\uffff' || c == ' ' || c == '\t') continue block9;
                    if (c == '\"') {
                        state = 2;
                        value = new StringBuilder();
                        break;
                    }
                    if (c == '-') {
                        state = 3;
                        key = new StringBuilder();
                        break;
                    }
                    value = new StringBuilder();
                    value.append(c);
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == '\uffff' || c == ' ' || c == '\t') {
                        this._argv.add(value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 2: {
                    if (c == '\uffff' || c == '\"') {
                        this._argv.add(value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 3: {
                    if (c == '\uffff' || c == ' ' || c == '\t') {
                        if (key.length() != 0) {
                            this._optv.add(key.toString());
                            this._optHash.put(key.toString(), "");
                            oneChar.append(key.toString());
                        }
                        state = 0;
                        break;
                    }
                    if (c == '=') {
                        value = new StringBuilder();
                        state = 4;
                        break;
                    }
                    if (c == '-') {
                        state = 3;
                        break;
                    }
                    key.append(c);
                    break;
                }
                case 4: {
                    if (c == '\uffff' || c == ' ' || c == '\t') {
                        if (key.length() != 0) {
                            this._optv.add(key.toString());
                            this._optHash.put(key.toString(), "");
                        }
                        state = 0;
                        break;
                    }
                    if (c == '\"') {
                        value = new StringBuilder();
                        state = 5;
                        break;
                    }
                    state = 6;
                    value = new StringBuilder();
                    value.append(c);
                    break;
                }
                case 5: {
                    if (c == '\uffff' || c == '\"') {
                        this._optv.add(key.toString());
                        this._optHash.put(key.toString(), value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 6: {
                    if (c == '\uffff' || c == ' ' || c == '\t') {
                        this._optv.add(key.toString());
                        this._optHash.put(key.toString(), value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                }
            }
        } while (c != '\uffff');
        this._oneChar = oneChar.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : ... <parseString>");
            System.exit(4);
        }
        Args lineArgs = null;
        lineArgs = args.length == 1 ? new Args(args[0]) : new Args(args);
        System.out.print(lineArgs.getInfo());
        System.out.println("pvr=" + lineArgs.getOpt("pvr"));
    }
}

