/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.clients;

import eu.emi.es.x2010.x12.activity.ListActivitiesDocument;
import eu.emi.es.x2010.x12.activity.ListActivitiesResponseDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusState;
import eu.unicore.emi.es.ActivityInfoService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.InvalidActivityLimitException;
import eu.unicore.emi.es.faults.InvalidParameterException;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class ActivityInfoClient {
    private final ActivityInfoService activityInfo;
    private final String url;
    private final IClientConfiguration sp;
    public static final String SERVICE_NAME = "ActivityInfoService";
    public static final String SERVICE_PATH = "/ActivityInfoService";

    public ActivityInfoClient(String _url, IClientConfiguration _clientProperties) throws MalformedURLException {
        this.url = _url;
        this.sp = _clientProperties;
        this.activityInfo = (ActivityInfoService)new UnicoreXFireClientFactory(_clientProperties).createPlainWSProxy(ActivityInfoService.class, _url);
    }

    public List<String> listActivities() throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesDocument lad = ListActivitiesDocument.Factory.newInstance();
        lad.addNewListActivities();
        return this.listActivities(lad);
    }

    public List<String> listActivities(long limit) throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesDocument lad = ListActivitiesDocument.Factory.newInstance();
        lad.addNewListActivities().setLimit(BigInteger.valueOf(limit));
        return this.listActivities(lad);
    }

    public List<String> listActivities(Calendar _from, Calendar _to) throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesDocument lad = ListActivitiesDocument.Factory.newInstance();
        ListActivitiesDocument.ListActivities la = lad.addNewListActivities();
        this.setDates(la, _from, _to);
        return this.listActivities(lad);
    }

    public List<String> listActivities(ActivityStatusState.Enum ... _status) throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesDocument lad = ListActivitiesDocument.Factory.newInstance();
        ListActivitiesDocument.ListActivities la = lad.addNewListActivities();
        this.setStatuses(la, _status);
        return this.listActivities(lad);
    }

    public List<String> listActivities(long _limit, Calendar _from, Calendar _to, ActivityStatusState.Enum ... _statuses) throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesDocument lad = ListActivitiesDocument.Factory.newInstance();
        ListActivitiesDocument.ListActivities la = lad.addNewListActivities();
        if (_limit > 0L) {
            la.setLimit(BigInteger.valueOf(_limit));
        }
        this.setDates(la, _from, _to);
        this.setStatuses(la, _statuses);
        return this.listActivities(lad);
    }

    private List<String> listActivities(ListActivitiesDocument lad) throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesResponseDocument ladrd = this.activityInfo.ListActivities(lad);
        return Arrays.asList(ladrd.getListActivitiesResponse().getActivityIDArray());
    }

    private void setDates(ListActivitiesDocument.ListActivities la, Calendar _from, Calendar _to) {
        if (_from != null) {
            la.setFromDate(_from);
        }
        if (_to != null) {
            la.setToDate(_to);
        }
    }

    private void setStatuses(ListActivitiesDocument.ListActivities la, ActivityStatusState.Enum ... _statuses) {
        ActivityStatusState.Enum[] enumArray = _statuses;
        int n = _statuses.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityStatusState.Enum status = enumArray[n2];
            la.addNewActivityStatus().setStatus(status);
            ++n2;
        }
    }

    public String getURL() {
        return this.url;
    }

    public IClientConfiguration getSecurityProperties() {
        return this.sp;
    }
}

