/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interfaces
implements DataSerializable {
    private boolean enabled = false;
    private final Set<String> interfaceSet = new HashSet<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Interfaces setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Interfaces addInterface(String ip) {
        this.interfaceSet.add(ip);
        return this;
    }

    public Interfaces clear() {
        this.interfaceSet.clear();
        return this;
    }

    public Collection<String> getInterfaces() {
        return Collections.unmodifiableCollection(this.interfaceSet);
    }

    public Interfaces setInterfaces(Collection<String> interfaces) {
        this.clear();
        this.interfaceSet.addAll(interfaces);
        return this;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        boolean hasInterfaceSet = this.interfaceSet != null && !this.interfaceSet.isEmpty();
        out.writeByte(ByteUtil.toByte(this.enabled, hasInterfaceSet));
        if (hasInterfaceSet) {
            out.writeInt(this.interfaceSet.size());
            for (String iface : this.interfaceSet) {
                out.writeUTF(iface);
            }
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        boolean[] b = ByteUtil.fromByte(in.readByte());
        this.enabled = b[0];
        boolean hasInterfaceSet = b[1];
        if (hasInterfaceSet) {
            this.interfaceSet.clear();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.interfaceSet.add(in.readUTF());
            }
        }
    }
}

