/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class StringAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#string";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String value;

    public StringAttribute(String string) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = string;
    }

    public static StringAttribute getInstance(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return new StringAttribute("");
        }
        short s = node2.getNodeType();
        if (s == 3 || s == 4 || s == 8) {
            return StringAttribute.getInstance(node2.getNodeValue());
        }
        return null;
    }

    public static StringAttribute getInstance(String string) {
        return new StringAttribute(string);
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringAttribute)) {
            return false;
        }
        StringAttribute stringAttribute = (StringAttribute)object;
        return this.value.equals(stringAttribute.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "StringAttribute: \"" + this.value + "\"";
    }

    public String encode() {
        return this.value;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

