/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class DoubleAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#double";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private double value;

    public DoubleAttribute(double d) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = d;
    }

    public static DoubleAttribute getInstance(Node node) throws NumberFormatException {
        return DoubleAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static DoubleAttribute getInstance(String string) {
        if (string.endsWith("INF")) {
            int n = string.lastIndexOf("INF");
            string = string.substring(0, n) + "Infinity";
        }
        return new DoubleAttribute(Double.parseDouble(string));
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleAttribute)) {
            return false;
        }
        DoubleAttribute doubleAttribute = (DoubleAttribute)object;
        if (Double.isNaN(this.value)) {
            return Double.isNaN(doubleAttribute.value);
        }
        return this.value == doubleAttribute.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public String encode() {
        return String.valueOf(this.value);
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

