/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeSelector
implements Evaluatable {
    private URI type;
    private String contextPath;
    private boolean mustBePresent;
    private String xpathVersion;
    private Node policyRoot;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$attr$AttributeSelector == null ? (class$com$sun$xacml$attr$AttributeSelector = AttributeSelector.class$("com.sun.xacml.attr.AttributeSelector")) : class$com$sun$xacml$attr$AttributeSelector).getName());
    static /* synthetic */ Class class$com$sun$xacml$attr$AttributeSelector;

    public AttributeSelector(URI uRI, String string, boolean bl, String string2) {
        this(uRI, string, null, bl, string2);
    }

    public AttributeSelector(URI uRI, String string, Node node, boolean bl, String string2) {
        this.type = uRI;
        this.contextPath = string;
        this.mustBePresent = bl;
        this.xpathVersion = string2;
        this.policyRoot = node;
    }

    public static AttributeSelector getInstance(Node node, String string) throws ParsingException {
        Node node2;
        URI uRI = null;
        String string2 = null;
        boolean bl = false;
        if (string == null) {
            throw new ParsingException("An XPathVersion is required for any policies that use selectors");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            uRI = new URI(namedNodeMap.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required DataType attribute in AttributeSelector", exception);
        }
        try {
            string2 = namedNodeMap.getNamedItem("RequestContextPath").getNodeValue();
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required RequestContextPath attribute in AttributeSelector", exception);
        }
        try {
            node2 = namedNodeMap.getNamedItem("MustBePresent");
            if (node2 != null && node2.getNodeValue().equals("true")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing optional attributes in AttributeSelector", exception);
        }
        node2 = null;
        for (Node node3 = node.getParentNode(); node3 != null && node3.getNodeType() == 1; node3 = node3.getParentNode()) {
            node2 = node3;
        }
        return new AttributeSelector(uRI, string2, node2, bl, string);
    }

    public URI getType() {
        return this.type;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    public boolean evaluatesToBag() {
        return true;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public EvaluationResult evaluate(EvaluationCtx evaluationCtx) {
        EvaluationResult evaluationResult = evaluationCtx.getAttribute(this.contextPath, this.policyRoot, this.type, this.xpathVersion);
        if (!evaluationResult.indeterminate()) {
            BagAttribute bagAttribute = (BagAttribute)evaluationResult.getAttributeValue();
            if (bagAttribute.isEmpty()) {
                if (this.mustBePresent) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("AttributeSelector failed to resolve a value for a required attribute: " + this.contextPath);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
                    String string = "couldn't resolve XPath expression " + this.contextPath + " for type " + this.type.toString();
                    return new EvaluationResult(new Status(arrayList, string));
                }
                return evaluationResult;
            }
            return evaluationResult;
        }
        return evaluationResult;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        String string2 = "<AttributeSelector RequestContextPath=\"" + this.contextPath + "\" DataType=\"" + this.type.toString() + "\"";
        if (this.mustBePresent) {
            string2 = string2 + " MustBePresent=\"true\"";
        }
        string2 = string2 + "/>";
        printStream.println(string + string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

