/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.TargetMatch;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Target {
    private List subjects;
    private List resources;
    private List actions;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$Target == null ? (class$com$sun$xacml$Target = Target.class$("com.sun.xacml.Target")) : class$com$sun$xacml$Target).getName());
    static /* synthetic */ Class class$com$sun$xacml$Target;

    public Target(List list, List list2, List list3) {
        this.subjects = list == null ? list : Collections.unmodifiableList(new ArrayList(list));
        this.resources = list2 == null ? list2 : Collections.unmodifiableList(new ArrayList(list2));
        this.actions = list3 == null ? list3 : Collections.unmodifiableList(new ArrayList(list3));
    }

    public static Target getInstance(Node node, String string) throws ParsingException {
        List list = null;
        List list2 = null;
        List list3 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("Subjects")) {
                list = Target.getAttributes(node2, "Subject", string);
                continue;
            }
            if (string2.equals("Resources")) {
                list2 = Target.getAttributes(node2, "Resource", string);
                continue;
            }
            if (!string2.equals("Actions")) continue;
            list3 = Target.getAttributes(node2, "Action", string);
        }
        return new Target(list, list2, list3);
    }

    private static List getAttributes(Node node, String string, String string2) throws ParsingException {
        ArrayList<List> arrayList = new ArrayList<List>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string3 = node2.getNodeName();
            if (string3.equals(string)) {
                arrayList.add(Target.getMatches(node2, string, string2));
                continue;
            }
            if (!string3.equals("Any" + string)) continue;
            return null;
        }
        return arrayList;
    }

    private static List getMatches(Node node, String string, String string2) throws ParsingException {
        ArrayList<TargetMatch> arrayList = new ArrayList<TargetMatch>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string3 = node2.getNodeName();
            if (!string3.equals(string + "Match")) continue;
            arrayList.add(TargetMatch.getInstance(node2, string, string2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getSubjects() {
        return this.subjects;
    }

    public List getResources() {
        return this.resources;
    }

    public List getActions() {
        return this.actions;
    }

    public MatchResult match(EvaluationCtx evaluationCtx) {
        MatchResult matchResult;
        if (this.subjects != null && (matchResult = this.checkSet(this.subjects, evaluationCtx)).getResult() != 0) {
            logger.finer("failed to match Subjects section of Target");
            return matchResult;
        }
        if (this.resources != null && (matchResult = this.checkSet(this.resources, evaluationCtx)).getResult() != 0) {
            logger.finer("failed to match Resources section of Target");
            return matchResult;
        }
        if (this.actions != null && (matchResult = this.checkSet(this.actions, evaluationCtx)).getResult() != 0) {
            logger.finer("failed to match Actions section of Target");
            return matchResult;
        }
        return new MatchResult(0);
    }

    private MatchResult checkSet(List list, EvaluationCtx evaluationCtx) {
        Iterator iterator = list.iterator();
        boolean bl = true;
        Status status = null;
        while (iterator.hasNext()) {
            TargetMatch targetMatch;
            List list2 = (List)iterator.next();
            Iterator iterator2 = list2.iterator();
            MatchResult matchResult = null;
            while (iterator2.hasNext() && (matchResult = (targetMatch = (TargetMatch)iterator2.next()).match(evaluationCtx)).getResult() == 0) {
            }
            if (matchResult.getResult() == 0) {
                return matchResult;
            }
            if (matchResult.getResult() != 2) continue;
            bl = false;
            if (status != null) continue;
            status = matchResult.getStatus();
        }
        if (bl) {
            return new MatchResult(1);
        }
        return new MatchResult(2, status);
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        printStream.println(string + "<Target>");
        indenter.in();
        this.encodeSection(printStream, indenter, "Subject", this.subjects);
        this.encodeSection(printStream, indenter, "Resource", this.resources);
        this.encodeSection(printStream, indenter, "Action", this.actions);
        indenter.out();
        printStream.println(string + "</Target>");
    }

    private void encodeSection(PrintStream printStream, Indenter indenter, String string, List list) {
        String string2 = indenter.makeString();
        printStream.println(string2 + "<" + string + "s>");
        indenter.in();
        String string3 = indenter.makeString();
        if (list == null) {
            printStream.println(string3 + "<Any" + string + "/>");
        } else {
            String string4 = indenter.makeString();
            Iterator iterator = list.iterator();
            indenter.in();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                printStream.println(string3 + "<" + string + ">");
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    TargetMatch targetMatch = (TargetMatch)iterator2.next();
                    targetMatch.encode(printStream, indenter);
                }
                printStream.println(string3 + "</" + string + ">");
            }
            indenter.out();
        }
        indenter.out();
        printStream.println(string2 + "</" + string + "s>");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

