/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.security.xfireutil.WSSecHeader;
import eu.unicore.security.xfireutil.client.Configurable;
import eu.unicore.security.xfireutil.client.DSigOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class SAMLAttributePushOutHandler
extends AbstractHandler
implements Configurable {
    private static final Logger log = Log.getLogger((String)"unicore.security", SAMLAttributePushOutHandler.class);
    public static final String PUSHED_RAW_ASSERTIONS = SAMLAttributePushOutHandler.class.getName() + ".RAW-SAML-TO-PUSH";
    public static final String PUSHED_ASSERTIONS = "SAMLPushedassertions";
    protected List<Element> toBeInserted = new ArrayList<Element>();
    protected List<Assertion> origList;

    public SAMLAttributePushOutHandler() {
        this.setPhase("post-invoke");
        this.before(DSigOutHandler.class.getName());
    }

    public SAMLAttributePushOutHandler(List<Assertion> assertions) throws JDOMException, IOException {
        this();
        this.convertToJDOM(assertions);
        this.origList = assertions;
    }

    @Override
    public void configure(IClientConfiguration properties) {
        Map secContext = properties.getExtraSecurityTokens();
        if (secContext == null) {
            log.debug((Object)"Extra security tokens are not set; SAML attributes won't be sent.");
            return;
        }
        Object assertionsO = secContext.get(PUSHED_ASSERTIONS);
        Object assertionsRawO = secContext.get(PUSHED_RAW_ASSERTIONS);
        if (assertionsO != null) {
            List assertions = (List)assertionsO;
            try {
                this.convertToJDOM(assertions);
                this.origList = assertions;
            }
            catch (Exception e) {
                log.error((Object)"Error when parsing SAML assertions.", (Throwable)e);
            }
        }
        if (assertionsRawO != null) {
            List assertionsRaw = (List)assertionsRawO;
            this.toBeInserted.addAll(assertionsRaw);
        }
        if (this.toBeInserted.size() == 0) {
            log.debug((Object)"Thre are no SAML assertions in extra security tokens; SAML attributes won't be sent.");
            return;
        }
        log.debug((Object)"Found SAML assertions to be sent, applying them");
    }

    public void invoke(MessageContext context) throws Exception {
        Boolean clientMode = (Boolean)context.getProperty("client.mode");
        if (clientMode == null || !clientMode.booleanValue()) {
            log.warn((Object)("Handler " + SAMLAttributePushOutHandler.class.getName() + " used in non-client mode, what does not make sense. " + "Check your configuration."));
            return;
        }
        if (this.toBeInserted == null || this.toBeInserted.size() == 0) {
            return;
        }
        log.debug((Object)"Adding SAML assertions to the request's header.");
        Element h = context.getOutMessage().getOrCreateHeader();
        WSSecHeader sec = new WSSecHeader(true);
        Element wsSecEl = sec.getOrInsertWSSecElement(h);
        for (Element o : this.toBeInserted) {
            Element c = (Element)o.clone();
            if (log.isTraceEnabled()) {
                XMLOutputter outputter = new XMLOutputter();
                outputter.setFormat(Format.getRawFormat());
                String jdomAssertion = outputter.outputString(c);
                log.trace((Object)jdomAssertion);
            }
            wsSecEl.addContent((Content)c);
        }
    }

    protected void convertToJDOM(List<Assertion> rawAssertions) throws JDOMException, IOException {
        for (Assertion a : rawAssertions) {
            AssertionDocument asDoc = a.getXML();
            Element elem = new SAXBuilder().build(asDoc.newInputStream()).detachRootElement();
            this.toBeInserted.add(elem);
        }
    }

    public List<Assertion> getOrigList() {
        return this.origList;
    }
}

