/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.xnjs;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import eu.emi.es.x2010.x12.types.ActivityStatusAttribute;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusState;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.security.Client;
import java.util.Calendar;

public final class XNJSToESActivityStateMapper {
    public static ActivityStatusDocument.ActivityStatus getESStatefromXNJSState(String xnjsActionId, Integer xnjsStatus, Client client, Kernel kernel) throws Exception {
        ActivityStatusDocument.ActivityStatus asType = ActivityStatusDocument.ActivityStatus.Factory.newInstance();
        XNJSHelper xnjs = XNJSHelper.get(kernel);
        if (xnjsStatus == null) {
            xnjsStatus = xnjs.getConfiguration().getEMSManager().getStatus(xnjsActionId, client);
        }
        switch (xnjsStatus) {
            case 0: {
                asType.setStatus(ActivityStatusState.ACCEPTED);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.VALIDATING.toString());
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.CLIENT_STAGEIN_POSSIBLE.toString());
                break;
            }
            case 4: {
                asType.setStatus(ActivityStatusState.PROCESSING_QUEUED);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.SERVER_PAUSED.toString());
                break;
            }
            case 3: {
                asType.setStatus(ActivityStatusState.PROCESSING_QUEUED);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.CLIENT_PAUSED.toString());
                break;
            }
            case 1: {
                asType.setStatus(ActivityStatusState.PREPROCESSING);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.CLIENT_STAGEIN_POSSIBLE.toString());
                break;
            }
            case 2: {
                asType.setStatus(ActivityStatusState.PROCESSING_ACCEPTING);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.CLIENT_STAGEIN_POSSIBLE.toString());
                break;
            }
            case 21: {
                asType.setStatus(ActivityStatusState.PROCESSING_ACCEPTING);
                break;
            }
            case 22: {
                asType.setStatus(ActivityStatusState.PROCESSING_QUEUED);
                break;
            }
            case 5: {
                asType.setStatus(ActivityStatusState.PROCESSING_RUNNING);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.APP_RUNNING.toString());
                break;
            }
            case 6: {
                asType.setStatus(ActivityStatusState.POSTPROCESSING);
                break;
            }
            case 7: {
                try {
                    asType.setStatus(ActivityStatusState.TERMINAL);
                    Action action = xnjs.getConfiguration().getInternalManager().getAction(xnjsActionId);
                    if (action.getResult().isSuccessful()) break;
                    if (action.getResult().getStatusCode() == 1) {
                        asType.addNewAttribute().setStringValue(ActivityStatusAttribute.PROCESSING_CANCEL.toString());
                        break;
                    }
                    asType.addNewAttribute().setStringValue(ActivityStatusAttribute.PROCESSING_FAILURE.toString());
                }
                catch (ExecutionException executionException) {}
                break;
            }
            case -1: {
                asType.setStatus(ActivityStatusState.POSTPROCESSING);
                asType.addNewAttribute().setStringValue(ActivityStatusAttribute.APP_FAILURE.toString());
                break;
            }
            case 8: {
                asType.setStatus(ActivityStatusState.TERMINAL);
            }
        }
        asType.addNewAttribute().setStringValue(ActivityStatusAttribute.CLIENT_STAGEOUT_POSSIBLE.toString());
        asType.setTimestamp(Calendar.getInstance());
        return asType;
    }

    public static ActivityStatusDocument.ActivityStatus getESStatefromXNJSState(String xnjsActionId, Client client, Kernel kernel) throws Exception {
        return XNJSToESActivityStateMapper.getESStatefromXNJSState(xnjsActionId, null, client, kernel);
    }

    public static ActivityStatusDocument.ActivityStatus getESStatefromXNJSState(String xnjsActionId, Kernel kernel) throws Exception {
        return XNJSToESActivityStateMapper.getESStatefromXNJSState(xnjsActionId, null, null, kernel);
    }
}

