/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.xnjs;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.io.DataStageOutInfo;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.jsdl.Incarnation;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.ExclusiveExecutionResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.adl.ApplicationDocument;
import eu.emi.es.x2010.x12.adl.CreationFlagEnumeration;
import eu.emi.es.x2010.x12.adl.DataStagingDocument;
import eu.emi.es.x2010.x12.adl.ExecutableType;
import eu.emi.es.x2010.x12.adl.InputFileDocument;
import eu.emi.es.x2010.x12.adl.OptionType;
import eu.emi.es.x2010.x12.adl.OutputFileDocument;
import eu.emi.es.x2010.x12.adl.ParallelEnvironmentDocument;
import eu.emi.es.x2010.x12.adl.ProcessesPerHostDocument;
import eu.emi.es.x2010.x12.adl.ResourcesDocument;
import eu.emi.es.x2010.x12.adl.RuntimeEnvironmentDocument;
import eu.emi.es.x2010.x12.adl.SlotRequirementDocument;
import eu.emi.es.x2010.x12.adl.SourceDocument;
import eu.emi.es.x2010.x12.adl.TargetDocument;
import eu.emi.es.x2010.x12.adl.ThreadsPerProcessDocument;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.emi.es.xnjs.DelegationCredentials;
import eu.unicore.jsdl.extensions.ArgumentDocument;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDocument;
import eu.unicore.security.Client;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JobProcessor
extends de.fzj.unicore.xnjs.ems.JobProcessor<ActivityDescriptionDocument> {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.emi.jobs", JobProcessor.class);

    public JobProcessor(Configuration config) {
        super(config);
    }

    void setAction(Action a) {
        this.action = a;
    }

    protected void extractFromJSDL() throws ExecutionException {
        ResourcesDocument.Resources resources;
        RuntimeEnvironmentDocument.RuntimeEnvironment[] re;
        Incarnation grounder = this.configuration.getGrounder();
        ActivityDescriptionDocument adl = (ActivityDescriptionDocument)this.getJobDescriptionDocument();
        ApplicationInfo ai = new ApplicationInfo();
        ApplicationDocument.Application app = adl.getActivityDescription().getApplication();
        if (app != null) {
            OptionType[] env;
            ExecutableType exec = app.getExecutable();
            if (exec != null) {
                ai.setExecutable(exec.getPath());
                String[] args = exec.getArgumentArray();
                if (args != null) {
                    ai.setArguments(args);
                }
            } else {
                logger.debug((Object)"No executable.");
            }
            if ((env = app.getEnvironmentArray()) != null) {
                OptionType[] optionTypeArray = env;
                int n = env.length;
                int n2 = 0;
                while (n2 < n) {
                    OptionType e = optionTypeArray[n2];
                    ai.getEnvironment().put(e.getName(), e.getValue());
                    ++n2;
                }
            }
        }
        if ((re = (resources = (resources = adl.getActivityDescription().getResources()) == null ? ResourcesDocument.Resources.Factory.newInstance() : resources).getRuntimeEnvironmentArray()) != null && re.length > 0) {
            if (re.length > 1) {
                throw new ExecutionException(31, "Too many runtime environments requested!");
            }
            RuntimeEnvironmentDocument.RuntimeEnvironment re1 = re[0];
            ai.setApplicationName(re1.getName());
            ai.setApplicationVersion(re1.getVersion());
        }
        if (resources != null) {
            ResourceSet req = this.parseResourceSet(resources);
            ResourceSet incarnatedResources = grounder.incarnateResources(req, this.action.getClient());
            this.action.getExecutionContext().setResourceRequest(incarnatedResources);
            ParallelEnvironmentDocument.ParallelEnvironment pEnv = resources.getParallelEnvironment();
            if (pEnv != null) {
                this.parseEE(pEnv, resources.getSlotRequirement());
            } else {
                this.action.setExecutionEnvironment(IncarnatedExecutionEnvironment.getDefault());
                this.action.addLogTrace("Using default execution environment.");
            }
        }
        boolean dataPush = false;
        if (adl.getActivityDescription().getDataStaging() != null) {
            dataPush = adl.getActivityDescription().getDataStaging().getClientDataPush();
        }
        if (!dataPush) {
            this.action.getProcessingContext().put((Object)"EMS_AUTOSUBMIT", (Object)Boolean.TRUE);
        }
        this.action.setApplicationInfo(grounder.incarnateApplication(ai));
        this.action.isDirty();
    }

    protected List<DataStageInInfo> extractStageInInfo() throws Exception {
        if (this.action.getStageIns() != null) {
            return this.action.getStageIns();
        }
        ArrayList<DataStageInInfo> stageIn = new ArrayList<DataStageInInfo>();
        DataStagingDocument.DataStaging ds = ((ActivityDescriptionDocument)this.getJobDescriptionDocument()).getActivityDescription().getDataStaging();
        if (ds != null) {
            InputFileDocument.InputFile[] inFiles;
            InputFileDocument.InputFile[] inputFileArray = inFiles = ds.getInputFileArray();
            int n = inFiles.length;
            int n2 = 0;
            while (n2 < n) {
                InputFileDocument.InputFile in = inputFileArray[n2];
                DataStageInInfo dsi = new DataStageInInfo();
                dsi.setFileName(in.getName());
                SourceDocument.Source[] sources = in.getSourceArray();
                if (sources != null && sources.length != 0) {
                    URI[] uris = new URI[sources.length];
                    int i = 0;
                    while (i < sources.length) {
                        uris[i] = new URI(sources[i].getURI());
                        String delegationID = sources[i].getDelegationID();
                        if (delegationID != null) {
                            dsi.setCredentials((DataStagingCredentials)new DelegationCredentials(delegationID));
                            if ("gsiftp".equalsIgnoreCase(uris[i].getScheme())) {
                                this.retrieveDelegation(delegationID);
                            }
                        }
                        ++i;
                    }
                    dsi.setSources(uris);
                    dsi.setOverwritePolicy(IFileTransfer.OverwritePolicy.OVERWRITE);
                    stageIn.add(dsi);
                }
                ++n2;
            }
        }
        this.action.setStageIns(stageIn);
        return stageIn;
    }

    protected List<DataStageOutInfo> extractStageOutInfo() throws Exception {
        if (this.action.getStageOuts() != null) {
            return this.action.getStageOuts();
        }
        ArrayList<DataStageOutInfo> stageOut = new ArrayList<DataStageOutInfo>();
        DataStagingDocument.DataStaging ds = ((ActivityDescriptionDocument)this.getJobDescriptionDocument()).getActivityDescription().getDataStaging();
        if (ds != null) {
            OutputFileDocument.OutputFile[] outFiles;
            OutputFileDocument.OutputFile[] outputFileArray = outFiles = ds.getOutputFileArray();
            int n = outFiles.length;
            int n2 = 0;
            while (n2 < n) {
                OutputFileDocument.OutputFile out = outputFileArray[n2];
                DataStageOutInfo dso = new DataStageOutInfo();
                dso.setFileName(out.getName());
                TargetDocument.Target[] targets = out.getTargetArray();
                if (targets.length > 0) {
                    TargetDocument.Target target = targets[0];
                    URI targetURI = new URI(target.getURI());
                    dso.setTarget(targetURI);
                    String delegationID = target.getDelegationID();
                    if (delegationID != null) {
                        dso.setCredentials((DataStagingCredentials)new DelegationCredentials(delegationID));
                        if ("gsiftp".equalsIgnoreCase(targetURI.getScheme())) {
                            this.retrieveDelegation(delegationID);
                        }
                    }
                    dso.setOverwritePolicy(this.convertCreationFlag(target.getCreationFlag()));
                    stageOut.add(dso);
                }
                ++n2;
            }
        }
        this.action.setStageOuts(stageOut);
        return stageOut;
    }

    private IFileTransfer.OverwritePolicy convertCreationFlag(CreationFlagEnumeration.Enum cf) {
        if (CreationFlagEnumeration.APPEND.equals(cf)) {
            return IFileTransfer.OverwritePolicy.APPEND;
        }
        if (CreationFlagEnumeration.DONT_OVERWRITE.equals(cf)) {
            return IFileTransfer.OverwritePolicy.DONT_OVERWRITE;
        }
        return IFileTransfer.OverwritePolicy.OVERWRITE;
    }

    protected void extractNotBefore() {
    }

    protected String getJobName() {
        return ((ActivityDescriptionDocument)this.getJobDescriptionDocument()).getActivityDescription().getActivityIdentification().getName();
    }

    protected boolean hasStageIn() {
        try {
            return this.extractStageInInfo().size() > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean hasStageOut() {
        try {
            return this.extractStageOutInfo().size() > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean isEmptyJob() {
        boolean noStaging;
        if (((ActivityDescriptionDocument)this.getJobDescriptionDocument()).getActivityDescription() == null) {
            return true;
        }
        boolean noApp = ((ActivityDescriptionDocument)this.getJobDescriptionDocument()).getActivityDescription().getApplication() == null;
        boolean bl = noStaging = ((ActivityDescriptionDocument)this.getJobDescriptionDocument()).getActivityDescription().getDataStaging() == null;
        return noApp && noStaging;
    }

    void retrieveDelegation(String delegationID) throws Exception {
        Client client = this.action.getClient();
        Kernel kernel = (Kernel)this.configuration.getComponentInstanceOfType(Kernel.class);
        String pem = XNJSHelper.get(kernel).getPEMEncodedProxyCert(delegationID);
        if (client != null && client.getSecurityTokens() != null) {
            client.getSecurityTokens().getContext().put("Proxy", pem);
        }
    }

    public ResourceSet parseResourceSet(ResourcesDocument.Resources requestedResources) {
        SlotRequirementDocument.SlotRequirement slots;
        BigInteger time;
        ResourceSet req = new ResourceSet();
        BigInteger mem = requestedResources.getIndividualPhysicalMemory();
        if (mem != null) {
            DoubleResource r = JSDLResourceSet.createDoubleResource((String)"MemoryPerNode", (double)mem.doubleValue(), (Resource.Category)Resource.Category.MEMORY);
            req.putResource((Resource)r);
        }
        if ((time = requestedResources.getIndividualCPUTime()) != null) {
            DoubleResource r = JSDLResourceSet.createDoubleResource((String)"CPUTime", (double)time.doubleValue(), (Resource.Category)Resource.Category.TIME);
            req.putResource((Resource)r);
        }
        if ((slots = requestedResources.getSlotRequirement()) != null && slots.getNumberOfSlots() != null) {
            boolean exclusive;
            boolean bl = exclusive = slots.isSetExclusiveExecution() && slots.getExclusiveExecution();
            if (exclusive) {
                ExclusiveExecutionResource ex = new ExclusiveExecutionResource(exclusive);
                req.putResource((Resource)ex);
            }
            int numSlots = slots.getNumberOfSlots().intValue();
            if (slots.getSlotsPerHost() != null) {
                SlotRequirementDocument.SlotRequirement.SlotsPerHost sph = slots.getSlotsPerHost();
                boolean useNumSlotsAsSlotsPerHost = sph.isSetUseNumberOfSlots() && sph.getUseNumberOfSlots();
                int slotsPerHost = useNumSlotsAsSlotsPerHost ? numSlots : sph.getBigIntegerValue().intValue();
                DoubleResource cpusPerNode = JSDLResourceSet.createDoubleResource((String)"CPUsPerNode", (double)slotsPerHost, (Resource.Category)Resource.Category.PROCESSING);
                req.putResource((Resource)cpusPerNode);
                int nodes = numSlots / slotsPerHost;
                DoubleResource nodesR = JSDLResourceSet.createDoubleResource((String)"Nodes", (double)nodes, (Resource.Category)Resource.Category.PROCESSING);
                req.putResource((Resource)nodesR);
            } else {
                DoubleResource totalCPUs = JSDLResourceSet.createDoubleResource((String)"TotalCPUs", (double)numSlots, (Resource.Category)Resource.Category.PROCESSING);
                req.putResource((Resource)totalCPUs);
            }
        }
        return req;
    }

    void parseEE(ParallelEnvironmentDocument.ParallelEnvironment pEnv, SlotRequirementDocument.SlotRequirement slots) throws ExecutionException {
        ThreadsPerProcessDocument.ThreadsPerProcess tpp;
        String name = pEnv.getType();
        IncarnatedExecutionEnvironment env = new IncarnatedExecutionEnvironment(name);
        ExecutionEnvironmentDocument.ExecutionEnvironment definedExecEnv = this.configuration.getIDB().getExecutionEnvironment(name);
        if (definedExecEnv == null) {
            throw new ExecutionException("No execution environment named <" + name + "> is defined at this site!");
        }
        if (definedExecEnv.getCommandlineTemplate() != null) {
            env.setCommandlineTemplate(definedExecEnv.getCommandlineTemplate());
        }
        env.setExecutable(definedExecEnv.getExecutableName());
        ArgumentDocument.Argument[] argumentArray = definedExecEnv.getArgumentArray();
        int n = argumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArgumentDocument.Argument arg = argumentArray[n2];
            OptionType reqArg = this.getRequestedOption(arg.getName(), pEnv.getOptionArray());
            if (reqArg != null) {
                env.addArgument(arg.getIncarnatedValue(), reqArg.getValue());
            }
            ++n2;
        }
        ProcessesPerHostDocument.ProcessesPerHost pph = pEnv.getProcessesPerHost();
        if (pph != null) {
            long processesPerHost = 1L;
            if (pph.isSetUseSlotsPerHost() && pph.getUseSlotsPerHost()) {
                if (slots.getSlotsPerHost() == null) {
                    throw new ExecutionException("Inconsistency between slot requirement and parallel environment ProcessesPerHost: if using 'useSlotsPerHost' you must specify the SlotRequirement.slotsPerHost value!");
                }
                processesPerHost = slots.getSlotsPerHost().getBigIntegerValue().longValue();
            } else if (pph.getBigIntegerValue() != null) {
                processesPerHost = pph.getBigIntegerValue().intValue();
            } else {
                throw new ExecutionException("Value required for ProcessesPerHost");
            }
            this.action.getExecutionContext().getEnvironment().put("UC_PROCESSES_PER_HOST", String.valueOf(processesPerHost));
            ArgumentDocument.Argument arg = this.getNamedArgument("ProcessesPerHost", definedExecEnv.getArgumentArray());
            if (arg != null) {
                env.addArgument(arg.getIncarnatedValue(), String.valueOf(processesPerHost));
            }
        }
        if ((tpp = pEnv.getThreadsPerProcess()) != null) {
            long threadsPerProcess = 1L;
            if (tpp.isSetUseSlotsPerHost() && tpp.getUseSlotsPerHost()) {
                if (slots.getSlotsPerHost() == null) {
                    throw new ExecutionException("Inconsistency between slot requirement and parallel environment ThreadsPerProcess: if using 'useSlotsPerHost' you must specify the SlotRequirement.slotsPerHost value!");
                }
                threadsPerProcess = slots.getSlotsPerHost().getBigIntegerValue().longValue();
            } else if (tpp.getBigIntegerValue() != null) {
                threadsPerProcess = tpp.getBigIntegerValue().intValue();
            } else {
                throw new ExecutionException("Value required for ThreadsPerProcess");
            }
            this.action.getExecutionContext().getEnvironment().put("UC_THREADS_PER_PROCESS", String.valueOf(threadsPerProcess));
            ArgumentDocument.Argument arg = this.getNamedArgument("ThreadsPerProcess", definedExecEnv.getArgumentArray());
            if (arg != null) {
                env.addArgument(arg.getIncarnatedValue(), String.valueOf(threadsPerProcess));
            }
        }
        this.action.setExecutionEnvironment(env);
    }

    private OptionType getRequestedOption(String name, OptionType[] requestedArgs) {
        OptionType[] optionTypeArray = requestedArgs;
        int n = requestedArgs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionType a = optionTypeArray[n2];
            if (name.equals(a.getName())) {
                return a;
            }
            ++n2;
        }
        return null;
    }

    private ArgumentDocument.Argument getNamedArgument(String name, ArgumentDocument.Argument[] available) {
        ArgumentDocument.Argument[] argumentArray = available;
        int n = available.length;
        int n2 = 0;
        while (n2 < n) {
            ArgumentDocument.Argument a = argumentArray[n2];
            if (a.getName().equals(name)) {
                return a;
            }
            ++n2;
        }
        return null;
    }
}

