/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.utils;

import de.fzj.unicore.uas.fts.http.FileServlet;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.XNJS;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.emi.es.x2010.x12.activity.ActivityInfoDocumentT;
import eu.emi.es.x2010.x12.activity.SessionDirectoryDocument;
import eu.emi.es.x2010.x12.activity.StageInDirectoryDocument;
import eu.emi.es.x2010.x12.activity.StageOutDirectoryDocument;
import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusAttribute;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.unicore.emi.es.EmiEsProperties;
import eu.unicore.emi.es.xnjs.XNJSToESActivityStateMapper;
import eu.unicore.security.Client;
import eu.unicore.security.SecurityTokens;
import eu.unicore.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.bouncycastle.openssl.PEMWriter;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;

public class XNJSHelper {
    private static final Logger logger = Log.getLogger((String)"unicore.services", XNJSHelper.class);
    private final EmiEsProperties properties;
    private final KeyStore proxyKeystore;
    private final HashMap<String, List<String>> activityList = new HashMap();
    private final XNJS xnjs;
    private final Kernel kernel;
    private final String proxyKSFile;
    private final String proxyKSPassword;
    private final String activityIDBase;
    public static final String glueNS = DomainsDocument.type.getDocumentElementName().getNamespaceURI();
    private static final QName state = new QName(glueNS, "State");
    private static final QName ID = new QName(glueNS, "ID");
    private static final QName IDFE = new QName(glueNS, "IDFromEndpoint");
    private static final QName ExitCode = new QName(glueNS, "ExitCode");
    private static final QName Owner = new QName(glueNS, "Owner");
    private static final QName StdOut = new QName(glueNS, "StdOut");
    private static final QName StdErr = new QName(glueNS, "StdErr");
    private static final QName StageInDirectory = StageInDirectoryDocument.type.getDocumentElementName();
    private static final QName StageOutDirectory = StageOutDirectoryDocument.type.getDocumentElementName();
    private static final QName SessionDirectory = SessionDirectoryDocument.type.getDocumentElementName();

    private XNJSHelper(Kernel kernel) throws Exception {
        this.kernel = kernel;
        EmiEsProperties props = (EmiEsProperties)((Object)kernel.getAttribute(EmiEsProperties.class));
        if (props == null) {
            props = new EmiEsProperties(kernel.getContainerProperties().getRawProperties());
            kernel.setAttribute(EmiEsProperties.class, (Object)props);
        }
        this.properties = (EmiEsProperties)((Object)kernel.getAttribute(EmiEsProperties.class));
        this.proxyKSFile = this.properties.getProxyKeystore();
        this.proxyKSPassword = this.properties.getProxyKeystorePassword();
        this.proxyKeystore = this.initializeProxyKeystore();
        String config = this.properties.getXnjsConfigFile();
        this.xnjs = this.initXNJS(config);
        this.activityIDBase = "urn:ogf:ComputingActivity:" + kernel.getContainerProperties().getBaseUrl() + "/EMI-ES-ACTIVITIES/";
    }

    private synchronized KeyStore initializeProxyKeystore() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        File ksFile = new File(this.proxyKSFile);
        if (ksFile.exists()) {
            ks.load(new FileInputStream(this.proxyKSFile), this.proxyKSPassword.toCharArray());
        }
        return ks;
    }

    public static synchronized XNJSHelper get(Kernel kernel) throws Exception {
        XNJSHelper xnjsHelper = (XNJSHelper)kernel.getAttribute(XNJSHelper.class);
        if (xnjsHelper == null) {
            xnjsHelper = new XNJSHelper(kernel);
            kernel.setAttribute(XNJSHelper.class, (Object)xnjsHelper);
        }
        return xnjsHelper;
    }

    private XNJS initXNJS(String path) throws Exception {
        XNJS xnjs = new XNJS(path);
        xnjs.getConfig().registerComponent((Object)this.kernel);
        xnjs.getConfig().registerComponent((Object)this.kernel.getClientConfiguration());
        xnjs.start();
        return xnjs;
    }

    public Configuration getConfiguration() {
        return this.xnjs.getConfig();
    }

    public Action createActivity(ActivityDescriptionDocument.ActivityDescription description, Client client) throws ExecutionException {
        ActivityDescriptionDocument add = ActivityDescriptionDocument.Factory.newInstance();
        add.setActivityDescription(description);
        Action a = this.getConfiguration().makeAction((XmlObject)add);
        this.getConfiguration().getEMSManager().add(a, client);
        return a;
    }

    public String[] getSessionDirURLs(Action a, boolean create) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (this.properties.isGridFTPEnabled()) {
            dirs.add(this.getGridFTPSessionDirURL(a));
        }
        if (this.properties.isHttpsEnabled()) {
            dirs.add(this.getHttpsSessionDirURL(a, create));
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    private String getGridFTPSessionDirURL(Action action) {
        String gridFTPBaseURL = this.properties.getGridFTPBaseURL();
        String uspace = action.getExecutionContext().getWorkingDirectory();
        return String.valueOf(gridFTPBaseURL) + uspace;
    }

    private String getHttpsSessionDirURL(Action action, boolean create) {
        String dir = action.getExecutionContext().getWorkingDirectory();
        TSI storage = this.xnjs.getConfig().getTargetSystemInterface(action.getClient());
        storage.setStorageRoot(dir);
        if (create) {
            FileServlet.initialise((Kernel)this.kernel);
            FileServlet fs = (FileServlet)this.kernel.getAttribute(FileServlet.class);
            if (fs.getResource(action.getUUID()) == null) {
                fs.exposeDirectory(action.getUUID(), "/", false, (IStorageAdapter)storage);
            }
        }
        String base = this.kernel.getContainerProperties().getBaseUrl();
        return String.valueOf(base.replace("services", "files")) + "/" + action.getUUID();
    }

    public String getOwner(String activityId) {
        try {
            return this.xnjs.getConfig().getInternalManager().getAction(activityId).getClient().getDistinguishedName();
        }
        catch (Exception ex) {
            return "n/a";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivity(Client client, String id) {
        HashMap<String, List<String>> hashMap = this.activityList;
        synchronized (hashMap) {
            List<String> ids = this.activityList.get(client.getDistinguishedName());
            if (ids == null) {
                ids = new ArrayList<String>();
                this.activityList.put(client.getDistinguishedName(), ids);
            }
            List<String> list = ids;
            synchronized (list) {
                ids.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAccess(Client client, String activityID) {
        HashMap<String, List<String>> hashMap = this.activityList;
        synchronized (hashMap) {
            List<String> ids = this.activityList.get(client.getDistinguishedName());
            if (ids == null) {
                ids = new ArrayList<String>();
                this.activityList.put(client.getDistinguishedName(), ids);
            }
            List<String> list = ids;
            synchronized (list) {
                return ids.contains(activityID);
            }
        }
    }

    public boolean hasDelegationId(String delegationID) {
        try {
            return this.proxyKeystore.containsAlias(delegationID);
        }
        catch (KeyStoreException e) {
            logger.warn((Object)("Unable to check proxy keystore for alias " + delegationID), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyCertificate(String delegationID, PrivateKey privateKey, X509Certificate proxy) throws Exception {
        KeyStore keyStore = this.proxyKeystore;
        synchronized (keyStore) {
            this.proxyKeystore.setKeyEntry(delegationID, privateKey, this.proxyKSPassword.toCharArray(), new X509Certificate[]{proxy});
            this.writeProxyKeystore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate getProxyCertificate(String delegationID) throws Exception {
        KeyStore keyStore = this.proxyKeystore;
        synchronized (keyStore) {
            return (X509Certificate)this.proxyKeystore.getCertificate(delegationID);
        }
    }

    public ActivityInfoDocumentT getActivityInfo(String id, QName[] attributeNames) throws Exception {
        String[] uspaces;
        int n;
        Action a = this.getConfiguration().getInternalManager().getAction(id);
        if (a == null) {
            return null;
        }
        ActivityInfoDocumentT activityInfo = ActivityInfoDocumentT.Factory.newInstance();
        if (this.accept(ID, attributeNames)) {
            activityInfo.setID(String.valueOf(this.activityIDBase) + id);
        }
        if (this.accept(IDFE, attributeNames)) {
            activityInfo.setIDFromEndpoint(id);
        }
        if (this.accept(state, attributeNames)) {
            ActivityStatusDocument.ActivityStatus as = XNJSToESActivityStateMapper.getESStatefromXNJSState(id, this.kernel);
            activityInfo.addState("emies:" + as.getStatus().toString());
            ActivityStatusAttribute.Enum[] enumArray = as.getAttributeArray();
            n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityStatusAttribute.Enum attr = enumArray[n2];
                activityInfo.addState("emiesattr:" + attr.toString());
                ++n2;
            }
        }
        if (this.accept(Owner, attributeNames)) {
            activityInfo.setOwner(this.getOwner(id));
        }
        ExecutionContext ec = a.getExecutionContext();
        if (this.accept(StdOut, attributeNames)) {
            activityInfo.setStdOut(ec.getStdout());
        }
        if (this.accept(StdErr, attributeNames)) {
            activityInfo.setStdErr(ec.getStderr());
        }
        if (this.accept(ExitCode, attributeNames) && ec.getExitCode() != null) {
            activityInfo.setExitCode(a.getExecutionContext().getExitCode().intValue());
        }
        String[] stringArray = uspaces = this.getSessionDirURLs(a, false);
        int n3 = uspaces.length;
        n = 0;
        while (n < n3) {
            String dir = stringArray[n];
            if (this.accept(SessionDirectory, attributeNames)) {
                activityInfo.addNewSessionDirectory().setStringValue(dir);
            }
            if (this.accept(StageInDirectory, attributeNames)) {
                activityInfo.addNewStageInDirectory().setStringValue(dir);
            }
            if (this.accept(StageOutDirectory, attributeNames)) {
                activityInfo.addNewStageOutDirectory().setStringValue(dir);
            }
            ++n;
        }
        for (String logEntry : a.getLog()) {
            activityInfo.addNewOtherInfo().setStringValue(logEntry);
        }
        return activityInfo;
    }

    public boolean accept(QName element, QName[] acceptedNames) {
        if (acceptedNames == null || acceptedNames.length == 0) {
            return true;
        }
        QName[] qNameArray = acceptedNames;
        int n = acceptedNames.length;
        int n2 = 0;
        while (n2 < n) {
            QName q = qNameArray[n2];
            if (q.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void startActivity(String id, Client client) throws ExecutionException {
        Action a = this.getConfiguration().getInternalManager().getAction(id);
        if (a == null) {
            throw new IllegalArgumentException("No such activity: " + id);
        }
        this.getConfiguration().getEMSManager().run(id, client);
    }

    private void writeProxyKeystore() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        FileOutputStream fos = null;
        try {
            File pksFile = new File(this.proxyKSFile);
            if (!pksFile.exists() && !pksFile.getParentFile().exists()) {
                pksFile.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(this.proxyKSFile);
            this.proxyKeystore.store(fos, this.proxyKSPassword.toCharArray());
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyCertificate(String delegationID, X509Certificate cert) throws Exception {
        KeyStore keyStore = this.proxyKeystore;
        synchronized (keyStore) {
            Key privateKey = this.proxyKeystore.getKey(delegationID, this.proxyKSPassword.toCharArray());
            X509Certificate clientCert = this.getClientCertFromRequest();
            if (this.kernel.getContainerSecurityConfiguration().isSslEnabled()) {
                logger.info((Object)("Client issuer DN: " + clientCert.getSubjectDN()));
                logger.info((Object)"Check proxy certificate validity...");
                cert.checkValidity();
                logger.info((Object)"Check proxy certificate with client public key... ");
                cert.verify(clientCert.getPublicKey());
                logger.info((Object)"Proxy certificate verified... ");
            }
            logger.info((Object)("Adding certificate chain to id " + delegationID));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)cert.toString());
                logger.debug((Object)clientCert.toString());
            }
            this.proxyKeystore.setKeyEntry(delegationID, privateKey, this.proxyKSPassword.toCharArray(), new Certificate[]{cert, clientCert});
            this.writeProxyKeystore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProxy(String delegationID) throws Exception {
        KeyStore keyStore = this.proxyKeystore;
        synchronized (keyStore) {
            this.proxyKeystore.deleteEntry(delegationID);
            this.writeProxyKeystore();
        }
    }

    public X509Certificate getClientCertFromRequest() throws CertificateException {
        X509Certificate[] certs;
        X509Certificate clientCert = null;
        SecurityTokens tokens = AuthZAttributeStore.getTokens();
        if (tokens != null && (clientCert = tokens.getUserCertificate()) == null) {
            clientCert = tokens.getConsignorCertificate();
        }
        if (clientCert == null && (certs = (X509Certificate[])XFireServletController.getRequest().getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
            clientCert = certs[0];
        }
        return clientCert;
    }

    public String getPEMEncodedProxyCert(String delegationID) throws Exception {
        StringWriter sb = new StringWriter();
        PEMWriter pw = new PEMWriter((Writer)sb);
        Certificate[] chain = this.proxyKeystore.getCertificateChain(delegationID);
        pw.writeObject((Object)chain[0]);
        pw.writeObject((Object)this.proxyKeystore.getKey(delegationID, this.proxyKSPassword.toCharArray()));
        pw.writeObject((Object)chain[1]);
        pw.flush();
        return sb.toString();
    }
}

