/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.utils;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryClient;
import eu.unicore.emi.es.info.ResourceInfoProvider;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.util.Log;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;

public class EmiEsStartup
implements Runnable {
    private static final Logger logger = Log.getLogger((String)"UNICORE_EMI-ES", EmiEsStartup.class);
    private final Kernel kernel;
    private final ResourceInfoProvider provider;
    private final String unique;

    public EmiEsStartup(Kernel kernel) {
        this.kernel = kernel;
        this.provider = ResourceInfoProvider.get(kernel);
        this.unique = kernel.getContainerProperties().getBaseUrl();
    }

    @Override
    public void run() {
        try {
            XNJSHelper.get(this.kernel);
            this.publishESServices();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void publishESServices() throws Exception {
        if (this.kernel.getService("Registry") == null) {
            logger.info((Object)"NULL registry reference");
            return;
        }
        LocalRegistryClient regClient = new LocalRegistryClient(this.kernel);
        logger.info((Object)"publishing emi-es entries to the local registry");
        if (this.kernel.getService("ActivityInfoService") != null) {
            String aInfoUrl = String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ActivityInfoService";
            ContentType aInfoContent = this.makeAInfoContent();
            regClient.addRegistryEntry(WSUtilities.makeServiceEPR((String)aInfoUrl, (QName)new QName("http://www.eu-emi.eu/es/2010/12/activity", "ActivityInfoService")), aInfoContent);
        }
        if (this.kernel.getService("ActivityManagementService") != null) {
            String aMgmtUrl = String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ActivityManagementService";
            ContentType aMgmtContent = this.makeAMgmtContent();
            regClient.addRegistryEntry(WSUtilities.makeServiceEPR((String)aMgmtUrl, (QName)new QName("http://www.eu-emi.eu/es/2010/12/activity", "ActivityManagementService")), aMgmtContent);
        }
        if (this.kernel.getService("CreateActivityService") != null) {
            String aCreateUrl = String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/CreateActivityService";
            ContentType aCreateContent = this.makeCActContent();
            regClient.addRegistryEntry(WSUtilities.makeServiceEPR((String)aCreateUrl, (QName)new QName("http://www.eu-emi.eu/es/2010/12/activity", "CreateActivityService")), aCreateContent);
        }
        if (this.kernel.getService("ResourceInfoService") != null) {
            String rInfoUrl = String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ResourceInfoService";
            ContentType rInfoContent = this.makeRInfoContent();
            regClient.addRegistryEntry(WSUtilities.makeServiceEPR((String)rInfoUrl, (QName)new QName("http://www.eu-emi.eu/es/2010/12/activity", "ResourceInfoService")), rInfoContent);
        }
        if (this.kernel.getService("DelegationService") != null) {
            String delegUrl = String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/DelegationService";
            ContentType delegContent = this.makeDelegContent();
            regClient.addRegistryEntry(WSUtilities.makeServiceEPR((String)delegUrl, (QName)new QName("http://www.eu-emi.eu/es/2010/12/activity", "DelegationService")), delegContent);
        }
    }

    private ContentType makeDelegContent() {
        ComputingEndpointT sd = this.provider.getDelegationEndpoint();
        ContentType ct = RegistryClient.makeContent((XmlObject[])new XmlObject[]{sd});
        return ct;
    }

    private ContentType makeAInfoContent() {
        ServiceDocument sd = this.wrapEndpoint(this.provider.getActivityInfoEndpoint());
        return RegistryClient.makeContent((XmlObject[])new XmlObject[]{sd});
    }

    private ContentType makeAMgmtContent() {
        ServiceDocument sd = this.wrapEndpoint(this.provider.getActivityManagementEndpoint());
        return RegistryClient.makeContent((XmlObject[])new XmlObject[]{sd});
    }

    private ContentType makeCActContent() {
        ServiceDocument sd = this.wrapEndpoint(this.provider.getActivityCreationEndpoint());
        return RegistryClient.makeContent((XmlObject[])new XmlObject[]{sd});
    }

    private ContentType makeRInfoContent() {
        ServiceDocument sd = this.wrapEndpoint(this.provider.getResourceInfoEndpoint());
        return RegistryClient.makeContent((XmlObject[])new XmlObject[]{sd});
    }

    private ServiceDocument wrapEndpoint(ComputingEndpointT endpoint) {
        ServiceDocument sd = ServiceDocument.Factory.newInstance();
        ServiceT service = sd.addNewService();
        service.setName("emi-es");
        service.setType("eu.unicore.USE");
        service.setID("urn:unicore:service:" + this.unique);
        String[] capabilities = endpoint.getCapabilityArray();
        service.setCapabilityArray(capabilities);
        EndpointT ep = service.addNewEndpoint();
        ep.setID(endpoint.getID());
        ep.setCapabilityArray(capabilities);
        ep.setTechnology("webservices");
        ep.setInterfaceName(endpoint.getInterfaceName());
        ep.setInterfaceVersionArray(endpoint.getInterfaceVersionArray());
        ep.setURL(endpoint.getURL());
        return sd;
    }
}

