/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.info;

import de.fzj.unicore.wsrflite.Kernel;
import java.util.HashSet;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointHealthStateT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.QualityLevelT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServingStateT;

public class ResourceInfoProvider {
    private final Kernel kernel;
    private final QualityLevelT.Enum qualityLevel = QualityLevelT.DEVELOPMENT;
    private final String version = "1.16";
    private final String technology = "webservice";

    private ResourceInfoProvider(Kernel kernel) {
        this.kernel = kernel;
    }

    public static synchronized ResourceInfoProvider get(Kernel kernel) {
        ResourceInfoProvider ip = (ResourceInfoProvider)kernel.getAttribute(ResourceInfoProvider.class);
        if (ip == null) {
            ip = new ResourceInfoProvider(kernel);
            kernel.setAttribute(ResourceInfoProvider.class, (Object)ip);
        }
        return ip;
    }

    public synchronized ComputingServiceT getComputingService() throws Exception {
        ComputingServiceT csT = ComputingServiceT.Factory.newInstance();
        csT.setID("urn:unicore:emi-es:" + this.kernel.getContainerProperties().getBaseUrl());
        csT.setQualityLevel(this.qualityLevel);
        csT.setType("eu.unicore.USE");
        csT.addNewBaseType().setStringValue("Service");
        ComputingEndpointT[] eps = new ComputingEndpointT[]{this.getDelegationEndpoint(), this.getActivityCreationEndpoint(), this.getActivityManagementEndpoint(), this.getResourceInfoEndpoint(), this.getActivityInfoEndpoint()};
        HashSet<String> allCapabilities = new HashSet<String>();
        ComputingEndpointT[] computingEndpointTArray = eps;
        int n = eps.length;
        int n2 = 0;
        while (n2 < n) {
            ComputingEndpointT ep = computingEndpointTArray[n2];
            String[] stringArray = ep.getCapabilityArray();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String capability = stringArray[n4];
                allCapabilities.add(capability);
                ++n4;
            }
            ++n2;
        }
        csT.setCapabilityArray(allCapabilities.toArray(new String[allCapabilities.size()]));
        csT.setComputingEndpointArray(eps);
        return csT;
    }

    public ComputingEndpointT getDelegationEndpoint() {
        ComputingEndpointT ep = ComputingEndpointT.Factory.newInstance();
        ep.addNewBaseType().setStringValue("Endpoint");
        ep.setInterfaceName("org.ogf.glue.emies.delegation");
        ep.addInterfaceVersion("1.16");
        ep.addCapability("security.delegation");
        ep.setURL(String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/DelegationService");
        ep.setQualityLevel(this.qualityLevel);
        ep.setID("urn:unicore:emi-es:" + this.kernel.getContainerProperties().getBaseUrl() + ":delegation");
        ep.setHealthState(EndpointHealthStateT.OK);
        ep.setServingState(ServingStateT.PRODUCTION);
        ep.setTechnology("webservice");
        return ep;
    }

    public ComputingEndpointT getActivityCreationEndpoint() {
        ComputingEndpointT ep = ComputingEndpointT.Factory.newInstance();
        ep.addNewBaseType().setStringValue("Endpoint");
        ep.setInterfaceName("org.ogf.glue.emies.activitycreation");
        ep.addInterfaceVersion("1.16");
        ep.addCapability("executionmanagement.jobcreation");
        ep.addCapability("executionmanagement.jobdescription");
        ep.addCapability("data.access.sessiondir.gsiftp");
        ep.addCapability("data.access.stageindir.gsiftp");
        ep.addCapability("data.access.stageoutdir.gsiftp");
        ep.addCapability("data.access.sessiondir.https");
        ep.addCapability("data.access.stageindir.https");
        ep.addCapability("data.access.stageoutdir.https");
        ep.addCapability("data.transfer.cepull.gsiftp");
        ep.addCapability("data.transfer.cepull.http");
        ep.addCapability("data.transfer.cepull.ftp");
        ep.addCapability("data.transfer.cepush.gsiftp");
        ep.addCapability("data.transfer.cepush.mailto");
        ep.addCapability("data.transfer.cepush.http");
        ep.addCapability("data.transfer.cepush.ftp");
        ep.setURL(String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/CreateActivityService");
        ep.setQualityLevel(this.qualityLevel);
        ep.setID("urn:unicore:emi-es:" + this.kernel.getContainerProperties().getBaseUrl() + ":activitycreation");
        ep.setHealthState(EndpointHealthStateT.OK);
        ep.setServingState(ServingStateT.PRODUCTION);
        ep.setTechnology("webservice");
        return ep;
    }

    public ComputingEndpointT getActivityManagementEndpoint() {
        ComputingEndpointT ep = ComputingEndpointT.Factory.newInstance();
        ep.addNewBaseType().setStringValue("Endpoint");
        ep.setInterfaceName("org.ogf.glue.emies.activitymanagement");
        ep.addInterfaceVersion("1.16");
        ep.addCapability("executionmanagement.jobmanagement");
        ep.addCapability("information.lookup.job");
        ep.addCapability("data.access.sessiondir.gsiftp");
        ep.addCapability("data.access.stageindir.gsiftp");
        ep.addCapability("data.access.stageoutdir.gsiftp");
        ep.addCapability("data.access.sessiondir.https");
        ep.addCapability("data.access.stageindir.https");
        ep.addCapability("data.access.stageoutdir.https");
        ep.addCapability("data.transfer.cepull.gsiftp");
        ep.addCapability("data.transfer.cepull.http");
        ep.addCapability("data.transfer.cepull.ftp");
        ep.addCapability("data.transfer.cepush.gsiftp");
        ep.addCapability("data.transfer.cepush.mailto");
        ep.addCapability("data.transfer.cepush.http");
        ep.addCapability("data.transfer.cepush.ftp");
        ep.setURL(String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ActivityManagementService");
        ep.setQualityLevel(this.qualityLevel);
        ep.setID("urn:unicore:emi-es:" + this.kernel.getContainerProperties().getBaseUrl() + ":activitymanagement");
        ep.setHealthState(EndpointHealthStateT.OK);
        ep.setServingState(ServingStateT.PRODUCTION);
        ep.setTechnology("webservice");
        return ep;
    }

    public ComputingEndpointT getResourceInfoEndpoint() {
        ComputingEndpointT ep = ComputingEndpointT.Factory.newInstance();
        ep.addNewBaseType().setStringValue("Endpoint");
        ep.setInterfaceName("org.ogf.glue.emies.resourceinfo");
        ep.addInterfaceVersion("1.16");
        ep.addCapability("information.discovery.resource");
        ep.addCapability("information.query.xpath1");
        ep.setURL(String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ResourceInfoService");
        ep.setQualityLevel(this.qualityLevel);
        ep.setID("urn:unicore:emi-es:" + this.kernel.getContainerProperties().getBaseUrl() + ":resourceinfo");
        ep.setHealthState(EndpointHealthStateT.OK);
        ep.setServingState(ServingStateT.PRODUCTION);
        ep.setTechnology("webservice");
        return ep;
    }

    public ComputingEndpointT getActivityInfoEndpoint() {
        ComputingEndpointT ep = ComputingEndpointT.Factory.newInstance();
        ep.addNewBaseType().setStringValue("Endpoint");
        ep.setInterfaceName("org.ogf.glue.emies.activityinfo");
        ep.addInterfaceVersion("1.16");
        ep.addCapability("information.discovery.job");
        ep.addCapability("information.lookup.job");
        ep.setURL(String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ActivityInfoService");
        ep.setQualityLevel(this.qualityLevel);
        ep.setID("urn:unicore:emi-es:" + this.kernel.getContainerProperties().getBaseUrl() + ":activityinfo");
        ep.setHealthState(EndpointHealthStateT.OK);
        ep.setServingState(ServingStateT.PRODUCTION);
        ep.setTechnology("webservice");
        return ep;
    }
}

