/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.info;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.emi.es.x2010.x12.activity.ActivityInfoDocumentT;
import eu.emi.es.x2010.x12.activity.ActivityInfoItemDocument;
import eu.emi.es.x2010.x12.activity.ActivityStatusItemDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoResponseDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusResponseDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.emi.es.xnjs.XNJSToESActivityStateMapper;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class ActivityInfoUtil {
    private static final Logger logger = Log.getLogger((String)"unicore.services", ActivityInfoUtil.class);

    public static GetActivityInfoResponseDocument getActivityInfo(GetActivityInfoDocument request, Kernel kernel) throws InternalBaseFault {
        try {
            GetActivityInfoResponseDocument ires = GetActivityInfoResponseDocument.Factory.newInstance();
            String[] activityIDs = request.getGetActivityInfo().getActivityIDArray();
            QName[] attributeNames = request.getGetActivityInfo().getAttributeNameArray();
            ArrayList<ActivityInfoItemDocument.ActivityInfoItem> aList = new ArrayList<ActivityInfoItemDocument.ActivityInfoItem>();
            Client client = AuthZAttributeStore.getClient();
            String[] stringArray = activityIDs;
            int n = activityIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String activityID = stringArray[n2];
                if (client == null || XNJSHelper.get(kernel).checkAccess(client, activityID)) {
                    ActivityInfoItemDocument.ActivityInfoItem infoItem = ActivityInfoItemDocument.ActivityInfoItem.Factory.newInstance();
                    infoItem.setActivityID(activityID);
                    if (attributeNames != null && attributeNames.length != 0) {
                        QName[] qNameArray = attributeNames;
                        int n3 = attributeNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            QName attribute_name = qNameArray[n4];
                            logger.info((Object)("Attribute name from getInfo: " + attribute_name.getLocalPart()));
                            ++n4;
                        }
                    }
                    ActivityInfoDocumentT activityInfo = XNJSHelper.get(kernel).getActivityInfo(activityID, attributeNames);
                    infoItem.setActivityInfoDocument(activityInfo);
                    aList.add(infoItem);
                }
                ++n2;
            }
            GetActivityInfoResponseDocument.GetActivityInfoResponse getActivityInfoResponse = GetActivityInfoResponseDocument.GetActivityInfoResponse.Factory.newInstance();
            getActivityInfoResponse.setActivityInfoItemArray(aList.toArray(new ActivityInfoItemDocument.ActivityInfoItem[aList.size()]));
            ires.setGetActivityInfoResponse(getActivityInfoResponse);
            return ires;
        }
        catch (Exception e) {
            Log.logException((String)"Error getting activity info", (Throwable)e);
            String msg = Log.createFaultMessage((String)"Error getting activity info", (Throwable)e);
            throw new InternalBaseFault(msg);
        }
    }

    public static GetActivityStatusResponseDocument getActivityStatus(GetActivityStatusDocument request, Kernel kernel) throws InternalBaseFault {
        try {
            GetActivityStatusResponseDocument statusResponse = GetActivityStatusResponseDocument.Factory.newInstance();
            String[] activityIdArry = request.getGetActivityStatus().getActivityIDArray();
            ArrayList<ActivityStatusItemDocument.ActivityStatusItem> activityStatusLst = new ArrayList<ActivityStatusItemDocument.ActivityStatusItem>();
            String[] stringArray = activityIdArry;
            int n = activityIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                String activity_id = stringArray[n2];
                ActivityStatusDocument.ActivityStatus status = XNJSToESActivityStateMapper.getESStatefromXNJSState(activity_id, kernel);
                ActivityStatusItemDocument.ActivityStatusItem statusItem = ActivityStatusItemDocument.ActivityStatusItem.Factory.newInstance();
                statusItem.setActivityID(activity_id);
                statusItem.setActivityStatus(status);
                activityStatusLst.add(statusItem);
                ++n2;
            }
            GetActivityStatusResponseDocument.GetActivityStatusResponse getActivityStatusResponse = GetActivityStatusResponseDocument.GetActivityStatusResponse.Factory.newInstance();
            getActivityStatusResponse.setActivityStatusItemArray(activityStatusLst.toArray(new ActivityStatusItemDocument.ActivityStatusItem[activityStatusLst.size()]));
            statusResponse.setGetActivityStatusResponse(getActivityStatusResponse);
            return statusResponse;
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Error getting status for activity.", (Throwable)e);
            Log.logException((String)msg, (Throwable)e, (Logger)logger);
            throw new InternalBaseFault(msg);
        }
    }
}

