/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.emi.es.x2010.x12.resourceinfo.DefaultQueryDialectsEnumType;
import eu.emi.es.x2010.x12.resourceinfo.GetResourceInfoDocument;
import eu.emi.es.x2010.x12.resourceinfo.GetResourceInfoResponseDocument;
import eu.emi.es.x2010.x12.resourceinfo.QueryResourceInfoDocument;
import eu.emi.es.x2010.x12.resourceinfo.QueryResourceInfoResponseDocument;
import eu.unicore.emi.es.ResourceInfoService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.InternalResourceInfoException;
import eu.unicore.emi.es.faults.NotSupportedQueryDialectException;
import eu.unicore.emi.es.faults.NotValidQueryStatementException;
import eu.unicore.emi.es.faults.ResourceInfoNotFoundException;
import eu.unicore.emi.es.faults.UnknownQueryException;
import eu.unicore.emi.es.info.ResourceInfoProvider;
import eu.unicore.util.Log;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;

public class ResourceInfoServiceImpl
implements ResourceInfoService,
KernelInjectable {
    private static final Logger logger = Log.getLogger((String)"emies.info.resource", ResourceInfoServiceImpl.class);
    private static final String glue_ns = DomainsDocument.type.getDocumentElementName().getNamespaceURI();
    private Kernel kernel;

    public void setKernel(Kernel k) {
        this.kernel = k;
    }

    public GetResourceInfoResponseDocument GetResourceInfo(GetResourceInfoDocument request) throws InternalResourceInfoException, AccessControlFault, ResourceInfoNotFoundException, InternalBaseFault {
        GetResourceInfoResponseDocument res = GetResourceInfoResponseDocument.Factory.newInstance();
        GetResourceInfoResponseDocument.GetResourceInfoResponse resT = res.addNewGetResourceInfoResponse();
        ResourceInfoProvider rip = ResourceInfoProvider.get(this.kernel);
        try {
            resT.addNewServices().addNewComputingService().set((XmlObject)rip.getComputingService());
        }
        catch (Exception e) {
            Log.logException((String)"Error in getting the resource information", (Throwable)e, (Logger)logger);
            throw new InternalBaseFault("Error in getting the resource information");
        }
        return res;
    }

    public QueryResourceInfoResponseDocument QueryResourceInfo(QueryResourceInfoDocument request) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        String dialect = request.getQueryResourceInfo().getQueryDialect();
        if (dialect != null && !dialect.equals(DefaultQueryDialectsEnumType.XPATH_1_0.toString())) {
            throw new NotSupportedQueryDialectException("Dialect " + dialect + " is not supported", null);
        }
        try {
            ResourceInfoProvider rip = ResourceInfoProvider.get(this.kernel);
            String query = WSUtilities.extractElementTextAsString((XmlObject)request.getQueryResourceInfo().getQueryExpression());
            ComputingServiceDocument csd = ComputingServiceDocument.Factory.newInstance();
            csd.setComputingService((ComputingServiceT)rip.getComputingService().copy());
            return this.executeXpath(query, csd);
        }
        catch (Exception e) {
            Log.logException((String)"Error in querying the resource information", (Throwable)e, (Logger)logger);
            throw new InternalBaseFault(Log.createFaultMessage((String)"Error in querying the resource information", (Throwable)e));
        }
    }

    private QueryResourceInfoResponseDocument executeXpath(String query, ComputingServiceDocument csd) throws Exception {
        XmlObject[] xpath;
        query = "declare default element namespace '" + glue_ns + "' ; " + query;
        QueryResourceInfoResponseDocument respD = QueryResourceInfoResponseDocument.Factory.newInstance();
        QueryResourceInfoResponseDocument.QueryResourceInfoResponse res = respD.addNewQueryResourceInfoResponse();
        XmlOptions options = new XmlOptions();
        XmlObject[] xmlObjectArray = xpath = csd.selectPath(query, options);
        int n = xpath.length;
        int n2 = 0;
        while (n2 < n) {
            XmlObject r = xmlObjectArray[n2];
            res.addNewQueryResourceInfoItem().set(r);
            ++n2;
        }
        return respD;
    }
}

