/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EmiEsProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unicore.configuration", EmiEsProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "EMI-ES.";
    private static final String PROXY_KEYSTORE_FILE = "delegation.proxyKeystoreFile";
    private static final String PROXY_KEYSTORE_PASSWORD = "delegation.proxyKeystorePassword";
    private static final String XNJS_CONFIG_FILE = "xnjsConfiguration";
    private static final String GRIDFTP_BASEURL = "dataAccess.gridFTPBaseURL";
    private static final String GRIDFTP_ENABLE = "dataAccess.gridFTPEnabled";
    private static final String HTTPS_ENABLE = "dataAccess.httpsEnabled";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    static {
        META.put(PROXY_KEYSTORE_FILE, new PropertyMD().setMandatory().setDescription("Path to the keystore for storing proxy certificates."));
        META.put(PROXY_KEYSTORE_PASSWORD, new PropertyMD().setMandatory().setDescription("Password of the keystore for storing proxy certificates."));
        META.put(XNJS_CONFIG_FILE, new PropertyMD().setMandatory().setDescription("XNJS configuration file for the EMI-ES services."));
        META.put(GRIDFTP_ENABLE, new PropertyMD("false").setDescription("Whether GridFTP should be 'advertised' for data access."));
        META.put(GRIDFTP_BASEURL, new PropertyMD("gsiftp://localhost:2811").setDescription("Base URL of the GridFTP server."));
        META.put(HTTPS_ENABLE, new PropertyMD("true").setDescription("Whether HTTPS should be enabled for directory access."));
    }

    public EmiEsProperties(Properties properties) throws ConfigurationException, IOException {
        super(PREFIX, properties, META, log);
    }

    public String getProxyKeystore() {
        return this.getValue(PROXY_KEYSTORE_FILE);
    }

    public String getProxyKeystorePassword() {
        return this.getValue(PROXY_KEYSTORE_PASSWORD);
    }

    public String getXnjsConfigFile() {
        return this.getFileValueAsString(XNJS_CONFIG_FILE, false);
    }

    public boolean isGridFTPEnabled() {
        return this.getBooleanValue(GRIDFTP_ENABLE);
    }

    public String getGridFTPBaseURL() {
        return this.getValue(GRIDFTP_BASEURL);
    }

    public boolean isHttpsEnabled() {
        return this.getBooleanValue(HTTPS_ENABLE);
    }
}

