/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.unicore.emi.es.DelegationService;
import eu.unicore.emi.es.faults.DelegationServiceException;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.util.Log;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Random;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequestHolder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.gridsite.namespaces.delegation2.DelegationExceptionDocument;
import org.gridsite.namespaces.delegation2.DestroyDocument;
import org.gridsite.namespaces.delegation2.GetNewProxyReqDocument;
import org.gridsite.namespaces.delegation2.GetNewProxyReqResponseDocument;
import org.gridsite.namespaces.delegation2.GetProxyReqDocument;
import org.gridsite.namespaces.delegation2.GetProxyReqResponseDocument;
import org.gridsite.namespaces.delegation2.PutProxyDocument;

public class DelegationServiceImpl
implements DelegationService,
KernelInjectable {
    private Kernel kernel;

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public GetNewProxyReqResponseDocument getNewProxyReq(GetNewProxyReqDocument request) throws DelegationServiceException {
        GetNewProxyReqResponseDocument resp = GetNewProxyReqResponseDocument.Factory.newInstance();
        resp.addNewGetNewProxyReqResponse();
        try {
            String delegationID = UUID.randomUUID().toString();
            String pem = this.issueCSR(delegationID);
            resp.getGetNewProxyReqResponse().setProxyRequest(pem);
            resp.getGetNewProxyReqResponse().setDelegationID(delegationID);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = Log.createFaultMessage((String)"Error creating proxy request", (Throwable)e);
            throw new DelegationServiceException(msg);
        }
        return resp;
    }

    public GetProxyReqResponseDocument getProxyReq(GetProxyReqDocument request) throws DelegationServiceException {
        GetProxyReqResponseDocument resp = GetProxyReqResponseDocument.Factory.newInstance();
        resp.addNewGetProxyReqResponse();
        String delegationID = request.getGetProxyReq().getDelegationID();
        try {
            if (delegationID == null) {
                throw new IllegalArgumentException("Delegation ID cannot be null");
            }
            XNJSHelper xh = XNJSHelper.get(this.kernel);
            if (xh.hasDelegationId(delegationID)) {
                throw new IllegalArgumentException("Delegation ID already exists!");
            }
            String pem = this.issueCSR(delegationID);
            resp.getGetProxyReqResponse().setGetProxyReqReturn(pem);
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Error creating proxy request", (Throwable)e);
            DelegationExceptionDocument.DelegationException ex = DelegationExceptionDocument.DelegationException.Factory.newInstance();
            ex.setMsg(msg);
            throw new DelegationServiceException(msg, ex);
        }
        return resp;
    }

    protected String issueCSR(String delegationID) throws Exception {
        X509Certificate client_cert = this.getCurrentClientCert();
        KeyPairGenerator kgen = KeyPairGenerator.getInstance("RSA");
        kgen.initialize(2048);
        KeyPair myKeyPair = kgen.generateKeyPair();
        X500Principal subject = new X500Principal(client_cert.getSubjectDN().toString());
        Random rnd = new Random();
        BigInteger certId = new BigInteger(16, rnd);
        SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)myKeyPair.getPublic().getEncoded());
        X500Name subjectX500Name = new X500Name(subject.getName());
        X509v3CertificateBuilder cb = new X509v3CertificateBuilder(subjectX500Name, certId, Calendar.getInstance().getTime(), Calendar.getInstance().getTime(), subjectX500Name, spki);
        JcaContentSignerBuilder jcacsb = new JcaContentSignerBuilder("SHA1withRSA");
        ContentSigner contentSigner = jcacsb.build(myKeyPair.getPrivate());
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(cb.build(contentSigner));
        PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(subjectX500Name, spki);
        XNJSHelper.get(this.kernel).addProxyCertificate(delegationID, myKeyPair.getPrivate(), cert);
        PKCS10CertificationRequestHolder holder = csrBuilder.build(contentSigner);
        StringWriter s = new StringWriter();
        PEMWriter pw = new PEMWriter((Writer)s);
        pw.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE REQUEST", holder.toASN1Structure().getDEREncoded()));
        pw.close();
        return s.toString();
    }

    public X509Certificate getCurrentClientCert() {
        return AuthZAttributeStore.getTokens().getEffectiveUserCertificate();
    }

    public void putProxy(PutProxyDocument requestDoc) throws DelegationServiceException {
        try {
            XNJSHelper xh = XNJSHelper.get(this.kernel);
            PutProxyDocument.PutProxy request = requestDoc.getPutProxy();
            String delegationID = request.getDelegationID();
            if (!xh.hasDelegationId(delegationID)) {
                throw new DelegationServiceException("Unknown delegation id " + delegationID);
            }
            PEMReader reader = new PEMReader((Reader)new StringReader(request.getProxy()));
            X509Certificate x509 = (X509Certificate)reader.readObject();
            xh.addProxyCertificate(delegationID, x509);
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Error in putProxy", (Throwable)e);
            Log.logException((String)"Error in putProxy", (Throwable)e);
            throw new DelegationServiceException(msg);
        }
    }

    public void destroy(DestroyDocument requestDoc) throws DelegationServiceException {
        try {
            XNJSHelper xh = XNJSHelper.get(this.kernel);
            String delegationID = requestDoc.getDestroy().getDelegationID();
            if (!xh.hasDelegationId(delegationID)) {
                throw new DelegationServiceException("Unknown delegation id " + delegationID);
            }
            xh.destroyProxy(delegationID);
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Error in destroy", (Throwable)e);
            throw new DelegationServiceException(msg);
        }
    }
}

