/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.xnjs.ems.Action;
import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.creation.ActivityCreationResponseDocument;
import eu.emi.es.x2010.x12.creation.CreateActivityDocument;
import eu.emi.es.x2010.x12.creation.CreateActivityResponseDocument;
import eu.emi.es.x2010.x12.creation.DirectoryReference;
import eu.emi.es.x2010.x12.types.ActivityStatusAttribute;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusState;
import eu.unicore.emi.es.CreateActivityService;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.emi.es.utils.Utils;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CreateActivityServiceImpl
implements CreateActivityService,
KernelInjectable {
    private static final Logger logger = Log.getLogger((String)"unicore.client", CreateActivityServiceImpl.class);
    private Kernel kernel;
    private String activityManagerURI;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
        this.activityManagerURI = String.valueOf(this.kernel.getContainerProperties().getBaseUrl()) + "/ActivityManagementService";
    }

    public CreateActivityResponseDocument CreateActivity(CreateActivityDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        ActivityDescriptionDocument.ActivityDescription[] activities = request.getCreateActivity().getActivityDescriptionArray();
        int serverLimit = 100;
        Utils.checkVectorLimits(activities.length, serverLimit);
        CreateActivityResponseDocument responseDoc = CreateActivityResponseDocument.Factory.newInstance();
        try {
            CreateActivityResponseDocument.CreateActivityResponse response = responseDoc.addNewCreateActivityResponse();
            ArrayList<ActivityCreationResponseDocument.ActivityCreationResponse> responseList = new ArrayList<ActivityCreationResponseDocument.ActivityCreationResponse>();
            ActivityDescriptionDocument.ActivityDescription[] activityDescriptionArray = activities;
            int n = activities.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityDescriptionDocument.ActivityDescription activity = activityDescriptionArray[n2];
                ActivityCreationResponseDocument.ActivityCreationResponse res = null;
                try {
                    res = this.makeActivity(activity);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                responseList.add(res);
                ++n2;
            }
            response.setActivityCreationResponseArray(responseList.toArray(new ActivityCreationResponseDocument.ActivityCreationResponse[responseList.size()]));
            responseDoc.setCreateActivityResponse(response);
        }
        catch (Exception e) {
            Log.logException((String)"Error creating activity", (Throwable)e, (Logger)logger);
            throw new InternalBaseFault("Error creating activity");
        }
        return responseDoc;
    }

    ActivityCreationResponseDocument.ActivityCreationResponse makeActivity(ActivityDescriptionDocument.ActivityDescription activityDescription) throws Exception {
        ActivityCreationResponseDocument.ActivityCreationResponse makeres = ActivityCreationResponseDocument.ActivityCreationResponse.Factory.newInstance();
        Client client = AuthZAttributeStore.getClient();
        Action a = XNJSHelper.get(this.kernel).createActivity(activityDescription, client);
        ActivityStatusDocument.ActivityStatus status = ActivityStatusDocument.ActivityStatus.Factory.newInstance();
        status.setStatus(ActivityStatusState.ACCEPTED);
        status.addAttribute(ActivityStatusAttribute.CLIENT_STAGEIN_POSSIBLE);
        makeres.setActivityStatus(status);
        DirectoryReference dir_ref = DirectoryReference.Factory.newInstance();
        String[] urlArray = XNJSHelper.get(this.kernel).getSessionDirURLs(a, true);
        dir_ref.setURLArray(urlArray);
        makeres.setStageInDirectory(dir_ref);
        XNJSHelper.get(this.kernel).registerActivity(client, a.getUUID());
        makeres.setActivityID(a.getUUID());
        makeres.setActivityMgmtEndpointURL(this.activityManagerURI);
        return makeres;
    }
}

