/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import eu.emi.es.x2010.x12.activity.GetActivityInfoDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoResponseDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.CancelActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.CancelActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.CancelActivityResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyMessageType;
import eu.emi.es.x2010.x12.activitymanagement.NotifyRequestItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyServiceDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyServiceResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.PauseActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.PauseActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.PauseActivityResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.RestartActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.RestartActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.ResumeActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.ResumeActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.ResumeActivityResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.WipeActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.WipeActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.WipeActivityResponseItemDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusState;
import eu.emi.es.x2010.x12.types.InternalBaseFaultType;
import eu.unicore.emi.es.ActivityManagementService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.UnknownAttributeException;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.emi.es.info.ActivityInfoUtil;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.emi.es.xnjs.XNJSToESActivityStateMapper;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ActivityManagementServiceImpl
implements ActivityManagementService,
KernelInjectable {
    private static final Logger logger = Log.getLogger((String)"unicore.client", ActivityManagementServiceImpl.class);
    private Kernel kernel;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public RestartActivityResponseDocument restartActivity(RestartActivityDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        throw InternalBaseFault.createFault((String)"Not implemented!", (int)1, (String)"Feature not implemented.");
    }

    public WipeActivityResponseDocument wipeActivity(WipeActivityDocument request) throws VectorLimitExceededFault, AccessControlFault, InternalBaseFault {
        try {
            WipeActivityResponseDocument wipeResponse = WipeActivityResponseDocument.Factory.newInstance();
            WipeActivityResponseDocument.WipeActivityResponse wipeActivityResponse = wipeResponse.addNewWipeActivityResponse();
            String[] activityIdArry = request.getWipeActivity().getActivityIDArray();
            Client client = AuthZAttributeStore.getClient();
            String[] stringArray = activityIdArry;
            int n = activityIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                WipeActivityResponseItemDocument.WipeActivityResponseItem responseItem;
                String activityId = stringArray[n2];
                ActivityStatusDocument.ActivityStatus status = XNJSToESActivityStateMapper.getESStatefromXNJSState(activityId, client, this.kernel);
                if (status.getStatus().equals(ActivityStatusState.TERMINAL)) {
                    logger.info((Object)("Wiping " + activityId));
                    XNJSHelper.get(this.kernel).getConfiguration().getEMSManager().destroy(activityId, client);
                    responseItem = wipeActivityResponse.addNewWipeActivityResponseItem();
                    responseItem.setActivityID(activityId);
                    BigInteger es_time = new BigInteger("0");
                    responseItem.setEstimatedTime(es_time);
                } else {
                    responseItem = wipeActivityResponse.addNewWipeActivityResponseItem();
                    responseItem.addNewInternalBaseFault().setMessage("Operation not allowed");
                    responseItem.getInternalBaseFault().setTimestamp(Calendar.getInstance());
                    responseItem.getInternalBaseFault().setDescription("Activity must be in TERMINAL state for wipe.");
                }
                ++n2;
            }
            return wipeResponse;
        }
        catch (Exception e) {
            throw InternalBaseFault.createFault((String)"Error wiping activity.", (int)0, (String)e.getMessage());
        }
    }

    public GetActivityStatusResponseDocument getActivityStatus(GetActivityStatusDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        return ActivityInfoUtil.getActivityStatus(request, this.kernel);
    }

    public GetActivityInfoResponseDocument getActivityInfo(GetActivityInfoDocument request) throws VectorLimitExceededFault, InternalBaseFault, UnknownAttributeException {
        return ActivityInfoUtil.getActivityInfo(request, this.kernel);
    }

    public CancelActivityResponseDocument cancelActivity(CancelActivityDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        try {
            CancelActivityResponseDocument cres = CancelActivityResponseDocument.Factory.newInstance();
            CancelActivityResponseDocument.CancelActivityResponse cancelActivityResponse = cres.addNewCancelActivityResponse();
            String[] activityIdArry = request.getCancelActivity().getActivityIDArray();
            Client client = AuthZAttributeStore.getClient();
            String[] stringArray = activityIdArry;
            int n = activityIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                String activityId = stringArray[n2];
                CancelActivityResponseItemDocument.CancelActivityResponseItem responseItem = cancelActivityResponse.addNewCancelActivityResponseItem();
                try {
                    logger.info((Object)("Aborting " + activityId));
                    XNJSHelper.get(this.kernel).getConfiguration().getEMSManager().abort(activityId, client);
                    responseItem.setActivityID(activityId);
                }
                catch (ExecutionException e) {
                    InternalBaseFaultType fault = responseItem.addNewInternalBaseFault();
                    String message = Log.createFaultMessage((String)("Cancel failed for activity " + activityId), (Throwable)e);
                    fault.setMessage(message);
                    fault.setTimestamp(Calendar.getInstance());
                }
                ++n2;
            }
            return cres;
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Error cancelling.", (Throwable)e);
            Log.logException((String)"Error cancelling", (Throwable)e, (Logger)logger);
            throw new InternalBaseFault(msg);
        }
    }

    public NotifyServiceResponseDocument notifyService(NotifyServiceDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        try {
            NotifyServiceResponseDocument notifyResponseDoc = NotifyServiceResponseDocument.Factory.newInstance();
            NotifyRequestItemDocument.NotifyRequestItem[] requestItemArry = request.getNotifyService().getNotifyRequestItemArray();
            ArrayList<NotifyResponseItemDocument.NotifyResponseItem> responseItemLst = new ArrayList<NotifyResponseItemDocument.NotifyResponseItem>();
            Client client = AuthZAttributeStore.getClient();
            NotifyRequestItemDocument.NotifyRequestItem[] notifyRequestItemArray = requestItemArry;
            int n = requestItemArry.length;
            int n2 = 0;
            while (n2 < n) {
                NotifyRequestItemDocument.NotifyRequestItem nrequest = notifyRequestItemArray[n2];
                String activityID = nrequest.getActivityID();
                NotifyMessageType.Enum msg = nrequest.getNotifyMessage();
                if (NotifyMessageType.CLIENT_DATAPUSH_DONE.equals(msg)) {
                    XNJSHelper.get(this.kernel).startActivity(activityID, client);
                }
                NotifyResponseItemDocument.NotifyResponseItem responseItem = NotifyResponseItemDocument.NotifyResponseItem.Factory.newInstance();
                responseItem.setActivityID(activityID);
                responseItem.setAcknowledgement("OK");
                responseItemLst.add(responseItem);
                ++n2;
            }
            NotifyServiceResponseDocument.NotifyServiceResponse notifyServiceResponse = NotifyServiceResponseDocument.NotifyServiceResponse.Factory.newInstance();
            notifyServiceResponse.setNotifyResponseItemArray(responseItemLst.toArray(new NotifyResponseItemDocument.NotifyResponseItem[responseItemLst.size()]));
            notifyResponseDoc.setNotifyServiceResponse(notifyServiceResponse);
            return notifyResponseDoc;
        }
        catch (Exception e) {
            throw new InternalBaseFault("Error performing notify " + e);
        }
    }

    public PauseActivityResponseDocument pauseActivity(PauseActivityDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        try {
            PauseActivityResponseDocument pauseResponse = PauseActivityResponseDocument.Factory.newInstance();
            String[] activityIdArry = request.getPauseActivity().getActivityIDArray();
            ArrayList<PauseActivityResponseItemDocument.PauseActivityResponseItem> responseItemLst = new ArrayList<PauseActivityResponseItemDocument.PauseActivityResponseItem>();
            String[] stringArray = activityIdArry;
            int n = activityIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                String activityId = stringArray[n2];
                XNJSHelper.get(this.kernel).getConfiguration().getEMSManager().pause(activityId, AuthZAttributeStore.getClient());
                logger.info((Object)"Job has been paused...");
                PauseActivityResponseItemDocument.PauseActivityResponseItem responseItem = PauseActivityResponseItemDocument.PauseActivityResponseItem.Factory.newInstance();
                responseItem.setActivityID(activityId);
                responseItemLst.add(responseItem);
                ++n2;
            }
            PauseActivityResponseDocument.PauseActivityResponse pauseActivityResponse = PauseActivityResponseDocument.PauseActivityResponse.Factory.newInstance();
            pauseActivityResponse.setPauseActivityResponseItemArray(responseItemLst.toArray(new PauseActivityResponseItemDocument.PauseActivityResponseItem[responseItemLst.size()]));
            pauseResponse.setPauseActivityResponse(pauseActivityResponse);
            return pauseResponse;
        }
        catch (Exception e) {
            String errorMessage = Log.createFaultMessage((String)"Error performing pause", (Throwable)e);
            throw new InternalBaseFault(errorMessage);
        }
    }

    public ResumeActivityResponseDocument resumeActivity(ResumeActivityDocument request) throws VectorLimitExceededFault, InternalBaseFault {
        try {
            ResumeActivityResponseDocument resumeResponse = ResumeActivityResponseDocument.Factory.newInstance();
            String[] activityIdArry = request.getResumeActivity().getActivityIDArray();
            ArrayList<ResumeActivityResponseItemDocument.ResumeActivityResponseItem> responseItemLst = new ArrayList<ResumeActivityResponseItemDocument.ResumeActivityResponseItem>();
            String[] stringArray = activityIdArry;
            int n = activityIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                String activityId = stringArray[n2];
                XNJSHelper.get(this.kernel).getConfiguration().getEMSManager().resume(activityId, AuthZAttributeStore.getClient());
                logger.info((Object)"Job has been resumed...");
                ResumeActivityResponseItemDocument.ResumeActivityResponseItem responseItem = ResumeActivityResponseItemDocument.ResumeActivityResponseItem.Factory.newInstance();
                responseItem.setActivityID(activityId);
                responseItemLst.add(responseItem);
                ++n2;
            }
            ResumeActivityResponseDocument.ResumeActivityResponse resumeActivityResponse = ResumeActivityResponseDocument.ResumeActivityResponse.Factory.newInstance();
            resumeActivityResponse.setResumeActivityResponseItemArray(responseItemLst.toArray(new ResumeActivityResponseItemDocument.ResumeActivityResponseItem[responseItemLst.size()]));
            resumeResponse.setResumeActivityResponse(resumeActivityResponse);
            return resumeResponse;
        }
        catch (Exception e) {
            throw new InternalBaseFault("Error performing resume " + e);
        }
    }
}

