/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.emi.es.x2010.x12.activity.ActivityInfoDocumentT;
import eu.emi.es.x2010.x12.activity.ActivityStatusDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoResponseDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusResponseDocument;
import eu.emi.es.x2010.x12.activity.ListActivitiesDocument;
import eu.emi.es.x2010.x12.activity.ListActivitiesResponseDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusAttribute;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusState;
import eu.unicore.emi.es.ActivityInfoService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.InvalidActivityLimitException;
import eu.unicore.emi.es.faults.InvalidParameterException;
import eu.unicore.emi.es.faults.OperationNotPossibleException;
import eu.unicore.emi.es.faults.UnableToRetrieveStatusException;
import eu.unicore.emi.es.faults.UnknownAttributeException;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.emi.es.info.ActivityInfoUtil;
import eu.unicore.emi.es.utils.XNJSHelper;
import eu.unicore.emi.es.xnjs.XNJSToESActivityStateMapper;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class ActivityInfoServiceImpl
implements ActivityInfoService,
KernelInjectable {
    private Kernel kernel;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ListActivitiesResponseDocument ListActivities(ListActivitiesDocument request) throws InternalBaseFault, InvalidActivityLimitException, InvalidParameterException, AccessControlFault, VectorLimitExceededFault {
        ListActivitiesResponseDocument lard = ListActivitiesResponseDocument.Factory.newInstance();
        ListActivitiesResponseDocument.ListActivitiesResponse lar = lard.addNewListActivitiesResponse();
        try {
            String[] activityIds;
            String[] stringArray = activityIds = this.getFilteredActivities(request);
            int n = activityIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                lar.addActivityID(id);
                ++n2;
            }
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Error listing activities", (Throwable)e);
            throw InternalBaseFault.createFault((String)msg, (int)2, null);
        }
        return lard;
    }

    private String[] getFilteredActivities(ListActivitiesDocument request) throws Exception {
        String[] activityIds = XNJSHelper.get(this.kernel).getConfiguration().getEMSManager().list(AuthZAttributeStore.getClient());
        ActivityStatusDocument.ActivityStatus[] statusArray = request.getListActivities().getActivityStatusArray();
        ArrayList<String> filteredByStatus = new ArrayList<String>();
        String[] stringArray = activityIds;
        int n = activityIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.activityInAnyOfTheseStates(id, statusArray)) {
                filteredByStatus.add(id);
            }
            ++n2;
        }
        ArrayList<String> filteredByTimeFrame = new ArrayList<String>();
        for (String id : filteredByStatus) {
            if (!this.activityWithinTimeFrame(id, request.getListActivities().getFromDate(), request.getListActivities().getToDate())) continue;
            filteredByTimeFrame.add(id);
        }
        if (request.getListActivities().isSetLimit() && filteredByTimeFrame.size() > request.getListActivities().getLimit().intValue()) {
            return filteredByTimeFrame.subList(0, request.getListActivities().getLimit().intValue()).toArray(new String[request.getListActivities().getLimit().intValue()]);
        }
        return filteredByTimeFrame.toArray(new String[filteredByTimeFrame.size()]);
    }

    private boolean activityWithinTimeFrame(String id, Calendar fromDate, Calendar toDate) throws Exception {
        if (fromDate == null && toDate == null) {
            return true;
        }
        ActivityInfoDocumentT info = XNJSHelper.get(this.kernel).getActivityInfo(id, null);
        if (fromDate == null) {
            return info.getSubmissionTime().before(toDate);
        }
        if (toDate == null) {
            return info.getSubmissionTime().after(fromDate);
        }
        return info.getSubmissionTime().after(fromDate) && info.getSubmissionTime().before(toDate);
    }

    private boolean activityInAnyOfTheseStates(String id, ActivityStatusDocument.ActivityStatus[] statusArray) throws Exception {
        if (statusArray == null || statusArray.length == 0) {
            return true;
        }
        ActivityStatusDocument.ActivityStatus status = XNJSToESActivityStateMapper.getESStatefromXNJSState(id, AuthZAttributeStore.getClient(), this.kernel);
        ActivityStatusDocument.ActivityStatus[] activityStatusArray = statusArray;
        int n = statusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityStatusDocument.ActivityStatus targetStatus = activityStatusArray[n2];
            if (status.getStatus().equals(targetStatus.getStatus())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean compare(ActivityStatusDocument.ActivityStatus activityState, ActivityStatusDocument.ActivityStatus request) {
        ActivityStatusState.Enum primaryReq = request.getStatus();
        ActivityStatusState.Enum state = activityState.getStatus();
        if (primaryReq != null && !primaryReq.equals(state)) {
            return false;
        }
        ActivityStatusAttribute.Enum[] attributesRequest = request.getAttributeArray();
        List<ActivityStatusAttribute.Enum> attributes = Arrays.asList(request.getAttributeArray());
        ActivityStatusAttribute.Enum[] enumArray = attributesRequest;
        int n = attributesRequest.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityStatusAttribute.Enum attr = enumArray[n2];
            if (!attributes.contains(attr)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public GetActivityInfoResponseDocument GetActivityInfo(GetActivityInfoDocument request) throws InternalBaseFault, VectorLimitExceededFault, UnknownAttributeException {
        return ActivityInfoUtil.getActivityInfo(request, this.kernel);
    }

    public GetActivityStatusResponseDocument GetActivityStatus(GetActivityStatusDocument request) throws InternalBaseFault, UnableToRetrieveStatusException, OperationNotPossibleException, VectorLimitExceededFault {
        return ActivityInfoUtil.getActivityStatus(request, this.kernel);
    }
}

