/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn.provider;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.messaging.IMessagingChannel;
import de.fzj.unicore.wsrflite.messaging.IMessagingProvider;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.MessagingException;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationConsumer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNMessage;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsn.b2.NotificationMessageHolderType;
import org.oasisOpen.docs.wsn.b2.NotifyDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WSNProvider
implements IMessagingProvider,
IMessagingChannel {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", WSNProvider.class);
    private static ConcurrentLinkedQueue<Message> queue;
    private static ScheduledExecutorService sender;
    private final Kernel kernel;

    public WSNProvider(Kernel k) {
        this.kernel = k;
        this.configure();
    }

    public void publish(Message msg) throws MessagingException {
        this.send(msg);
    }

    public IMessagingChannel getChannel() {
        return this;
    }

    public static IMessagingChannel getDeadLetterChannel() {
        return new IMessagingChannel(){

            public void publish(Message message) throws MessagingException {
            }
        };
    }

    public synchronized void configure() {
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
            Runner r = new Runner();
            sender = Executors.newScheduledThreadPool(1);
            sender.scheduleWithFixedDelay(r, 1L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void send(Message m) {
        queue.add(m);
    }

    private void doSend(WSNMessage msg) throws MessagingException {
        try {
            NotificationMessageHolderType[] messages = (NotificationMessageHolderType[])msg.getBody();
            String url = msg.getTo().getAddress().getStringValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WS-N publish to " + url));
            }
            WSRFClientFactory clientFactory = new WSRFClientFactory((IClientConfiguration)this.kernel.getClientConfiguration());
            NotificationConsumer nc = (NotificationConsumer)clientFactory.createProxy(NotificationConsumer.class, url, msg.getTo());
            NotifyDocument nd = NotifyDocument.Factory.newInstance();
            nd.addNewNotify().setNotificationMessageArray(messages);
            nc.Notify(nd);
        }
        catch (Exception e) {
            Log.logException((String)"Could not send message.", (Throwable)e, (Logger)logger);
            throw new MessagingException((Throwable)e);
        }
    }

    protected BaseWSRFClient getClient(String url, EndpointReferenceType epr) throws Exception {
        return new BaseWSRFClient(url, epr, (IClientConfiguration)this.kernel.getClientConfiguration().clone());
    }

    private final class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            Message m;
            while ((m = (Message)queue.poll()) != null) {
                try {
                    WSNProvider.this.doSend((WSNMessage)m);
                }
                catch (Throwable e) {
                    try {
                        logger.error((Object)"Error sending WSN message.", e);
                        WSNProvider.getDeadLetterChannel().publish(m);
                    }
                    catch (Throwable t) {
                        Log.logException((String)"Error sending message to dead letter channel.", (Throwable)t, (Logger)logger);
                    }
                }
            }
        }
    }
}

