/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn.impl;

import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.Event;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.IServerSubscription;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNTopicExpression;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.Filters;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.WSNTopicExpressionBuilder;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsn.b2.ConsumerReferenceDocument;
import org.oasisOpen.docs.wsn.b2.CreationTimeDocument;
import org.oasisOpen.docs.wsn.b2.FilterDocument;
import org.oasisOpen.docs.wsn.b2.FilterType;
import org.oasisOpen.docs.wsn.b2.SubscriptionPolicyDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionType;

public class SubscriptionImpl
extends WSResourceImpl
implements IServerSubscription {
    protected static final Logger logger = Log.getLogger((String)"unicore.services", SubscriptionImpl.class);
    public static final String ConsumerRefKey = SubscriptionImpl.class.getName() + "_consumer";
    public static final String FilterKey = SubscriptionImpl.class.getName() + "_filter";
    public static final String MessageContentKey = SubscriptionImpl.class.getName() + "_messagecontent";
    public static final String SubscrPolicy = SubscriptionImpl.class.getName() + "_policy";
    public static final String CreationTimeKey = SubscriptionImpl.class.getName() + "_creation";
    public static final String NotificationProducerRefKey = SubscriptionImpl.class.getName() + "_producer";
    @Persist
    private String producerId;
    @Persist
    private TopicExpressionType topicExpression;
    @Persist
    private String messageContent;

    @Override
    public void initialise(String serviceName, Map<String, Object> map) throws Exception {
        CreationTimeDocument c;
        SubscriptionPolicyDocument s;
        super.initialise(serviceName, map);
        this.producerId = (String)map.get(NotificationProducerRefKey);
        ConsumerReferenceDocument epr = (ConsumerReferenceDocument)map.get(ConsumerRefKey);
        this.properties.put(RPConsumerReference, new ImmutableResourceProperty((XmlObject)epr));
        FilterDocument f = (FilterDocument)map.get(FilterKey);
        if (f != null) {
            this.properties.put(RPFilter, new ImmutableResourceProperty((XmlObject)f));
            this.processFilter(f);
        }
        if ((s = (SubscriptionPolicyDocument)map.get(SubscrPolicy)) != null) {
            this.properties.put(RPSubscriptionPolicy, new ImmutableResourceProperty((XmlObject)s));
        }
        if ((c = (CreationTimeDocument)map.get(CreationTimeKey)) != null) {
            this.properties.put(RPCreationTime, new ImmutableResourceProperty((XmlObject)c));
        }
    }

    protected void processFilter(FilterDocument filter) {
        try {
            this.topicExpression = (TopicExpressionType)WSUtilities.extractAny((XmlObject)filter.getFilter(), (QName)TopicExpressionDocument.type.getDocumentElementName())[0];
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
        }
        try {
            this.messageContent = Filters.extractXPathMessageContentFilter((FilterType)filter.getFilter());
            if (this.messageContent != null) {
                logger.debug((Object)("Have message content filter expression: " + this.messageContent));
            }
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
        }
    }

    public void destroy() {
        try {
            Message m = new Message((Serializable)((Object)("deleted:" + this.getUniqueID())));
            String uID = WSUtilities.extractResourceID((String)this.producerId);
            this.home.getKernel().getMessaging().getChannel(uID).publish(m);
        }
        catch (Exception e) {
            Log.logException((String)"Could not send internal message.", (Throwable)e, (Logger)logger);
        }
    }

    public ConsumerReferenceDocument getConsumerReference() {
        return (ConsumerReferenceDocument)this.getResourcePropertyXML(RPConsumerReference)[0];
    }

    public String getMessageContentFilter() {
        return this.messageContent;
    }

    public CreationTimeDocument getCreationTime() {
        return (CreationTimeDocument)this.getResourcePropertyXML(RPCreationTime)[0];
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return null;
    }

    public boolean match(Event event) {
        try {
            WSNTopicExpression expr = WSNTopicExpressionBuilder.buildExpression((TopicExpressionType)this.topicExpression);
            return expr.matches(event.getTopic());
        }
        catch (Exception e) {
            logger.info((Object)("Problem while matching WSN expression: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public TopicExpressionType getTopicExpression() {
        return this.topicExpression;
    }
}

