/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.rp;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class AddressListResourceProperty
extends ResourceProperty<EndpointReferenceType[]> {
    private static final long serialVersionUID = 1L;
    protected transient XmlObject[] xdoc;
    private final QName docName;
    private final String serviceName;
    private final QName portType;
    private final boolean addServerIdentity;
    private final List<String> uids = new ArrayList<String>();

    public AddressListResourceProperty(Resource parent, String serviceName, QName docElementName, QName portType, boolean addServerIdentity) {
        super(parent);
        this.docName = docElementName;
        this.portType = portType;
        this.serviceName = serviceName;
        this.addServerIdentity = addServerIdentity;
    }

    protected XmlObject getFullAddress(int index) throws Exception {
        XmlObject address = this.makeWrapperDoc();
        EndpointReferenceType epr = this.getEPR(index);
        WSUtilities.append((XmlObject)epr, (XmlObject)address);
        return address;
    }

    protected EndpointReferenceType getEPR(int index) throws Exception {
        String uid = this.uids.get(index);
        Kernel k = this.parentWSResource.getKernel();
        EndpointReferenceType epr = WSServerUtilities.makeEPR(this.serviceName, uid, this.portType, this.addServerIdentity, k);
        return epr;
    }

    @Override
    public XmlObject[] getXml() {
        XmlObject[] result = new XmlObject[this.uids.size()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = this.getFullAddress(i);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XmlObject> getXml(int offset, int length) throws IndexOutOfBoundsException {
        ArrayList<XmlObject> result = new ArrayList<XmlObject>();
        List<String> list = this.uids;
        synchronized (list) {
            for (int i = 0; i < length && i + offset < this.uids.size(); ++i) {
                try {
                    result.add(this.getFullAddress(i + offset));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String uid) {
        List<String> list = this.uids;
        synchronized (list) {
            return this.uids.add(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String uid) {
        List<String> list = this.uids;
        synchronized (list) {
            return this.uids.remove(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<String> list = this.uids;
        synchronized (list) {
            this.uids.clear();
        }
    }

    public List<String> getUIDs() {
        return Collections.unmodifiableList(this.uids);
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    private XmlObject makeWrapperDoc() throws Exception {
        ClassLoader cl = this.getClassLoader();
        SchemaType st = XmlBeans.typeLoaderForClassLoader((ClassLoader)cl).findDocumentType(this.docName);
        SchemaProperty[] sp = st.getElementProperties();
        String pName = sp[0].getJavaPropertyName();
        XmlObject pDoc = XmlObject.Factory.newInstance().changeType(st);
        Method adder = pDoc.getClass().getMethod("addNew" + pName, new Class[0]);
        adder.invoke((Object)pDoc, (Object[])null);
        return pDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfElements() {
        List<String> list = this.uids;
        synchronized (list) {
            return this.uids.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReferenceType[] getProperty() {
        List<String> list = this.uids;
        synchronized (list) {
            EndpointReferenceType[] result = new EndpointReferenceType[this.uids.size()];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = this.getEPR(i);
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(EndpointReferenceType[] setTo) {
        List<String> list = this.uids;
        synchronized (list) {
            this.uids.clear();
            for (int i = 0; i < setTo.length; ++i) {
                try {
                    String uid = WSUtilities.extractResourceID((EndpointReferenceType)setTo[i]);
                    this.uids.add(uid);
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

