/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.ExternalRegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryFinder;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHomeImpl;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.PropertyChangeListener;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.services", RegistryHandler.class);
    protected static final int initial = 20;
    protected static final int period = 20;
    private final Set<String> externalRegistryURLs = new HashSet<String>();
    private LocalRegistryClient registryClient = null;
    protected ScheduledExecutorService scheduledExecutor = null;
    private final Kernel kernel;
    private boolean isGlobalRegistry = false;
    private ContainerProperties config;

    public RegistryHandler(Kernel kernel) throws Exception {
        this.kernel = kernel;
        this.config = kernel.getContainerProperties();
        this.config.addPropertyChangeListener(new PropertyChangeListener(){
            private final String[] PROPS = new String[]{"externalregistry.use", "externalregistry.autodiscover", "externalregistry.url"};

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChanged(String propertyKey) {
                logger.info((Object)"Registry settings update detected: updating external registry settings.");
                1 var2_2 = this;
                synchronized (var2_2) {
                    RegistryHandler.this.externalRegistryURLs.clear();
                    RegistryHandler.this.updateExternalRegistryURLs();
                }
            }

            public String[] getInterestingProperties() {
                return this.PROPS;
            }
        });
        Home regHome = kernel.getHome("Registry");
        if (regHome != null && regHome instanceof RegistryHomeImpl) {
            this.isGlobalRegistry = true;
        }
        this.updateExternalRegistryURLs();
        if (regHome == null) {
            return;
        }
        try {
            this.registryClient = new LocalRegistryClient("default_registry", kernel);
        }
        catch (Exception ex) {
            logger.fatal((Object)"Could not create client for local registry!", (Throwable)ex);
        }
    }

    public synchronized String[] getExternalRegistryURLs() {
        return this.externalRegistryURLs.toArray(new String[this.externalRegistryURLs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalRegistryURLs() {
        boolean usesExternal;
        if (this.isGlobalRegistry) {
            logger.debug((Object)"This is a global registry. No external registry used.");
        }
        if (!(usesExternal = this.config.getBooleanValue("externalregistry.use").booleanValue())) {
            logger.debug((Object)"Usage of external registry is switched off. No external registry used.");
        }
        if (!this.isGlobalRegistry && usesExternal) {
            logger.debug((Object)"Determining external registry address(es) ...");
            if (this.config.getBooleanValue("externalregistry.autodiscover").booleanValue()) {
                logger.debug((Object)"Setting up auto-discovery of external registry.");
                if (this.scheduledExecutor == null) {
                    logger.debug((Object)"Scheduling repeated auto-discovery.");
                    RegistryFinder finder = new RegistryFinder(this.kernel);
                    finder.run();
                    this.scheduledExecutor = Executors.newScheduledThreadPool(1);
                    this.scheduledExecutor.scheduleAtFixedRate((Runnable)((Object)finder), 20L, 20L, TimeUnit.SECONDS);
                }
            } else {
                logger.debug((Object)"Auto-discovery of external registry switched off.");
            }
            Set<String> set = this.externalRegistryURLs;
            synchronized (set) {
                if (this.externalRegistryURLs.size() == 0) {
                    logger.debug((Object)"Trying to use manual settings for external registry.");
                    List registryUrls = this.config.getListOfValues("externalregistry.url");
                    for (String registryURL : registryUrls) {
                        if (registryURL == null || registryURL.length() <= 0) continue;
                        String u = registryURL.trim();
                        this.externalRegistryURLs.add(u);
                        logger.info((Object)("Using registry: " + u));
                    }
                }
            }
            if (this.externalRegistryURLs.size() == 0) {
                logger.warn((Object)"No external registry URLs are defined!");
            }
        }
    }

    public static EndpointReferenceType makeEPR(String url) {
        String resID = WSUtilities.extractResourceID((String)url);
        if (resID == null) {
            throw new IllegalArgumentException("The URL " + url + " doesn't provide resource identifier");
        }
        EndpointReferenceType epr = WSUtilities.makeServiceEPR((String)url);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr, (String)resID);
        return epr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExternalRegistryURL(String url) {
        Set<String> set = this.externalRegistryURLs;
        synchronized (set) {
            this.externalRegistryURLs.add(url);
        }
    }

    public LocalRegistryClient getRegistryClient() throws Exception {
        return this.registryClient;
    }

    public boolean usesExternalRegistry() {
        return this.config.getBooleanValue("externalregistry.use");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalRegistryClient getExternalRegistryClient() throws Exception {
        if (!this.config.getBooleanValue("externalregistry.use").booleanValue()) {
            return null;
        }
        ExternalRegistryClient reg = new ExternalRegistryClient();
        Set<String> set = this.externalRegistryURLs;
        synchronized (set) {
            for (String url : this.externalRegistryURLs) {
                try {
                    reg.addClient((BaseWSRFClient)new RegistryClient(url, RegistryHandler.makeEPR(url), (IClientConfiguration)this.kernel.getClientConfiguration()));
                }
                catch (Exception e) {
                    logger.error((Object)("Could not create client for external registry at <" + url + ">"), (Throwable)e);
                }
            }
        }
        reg.setMode(1);
        return reg;
    }

    public String getRegistryConnectionStatus() {
        try {
            if (!this.usesExternalRegistry()) {
                return "N/A (no external registry used)";
            }
            String[] urls = this.getExternalRegistryURLs();
            ExternalRegistryClient erc = this.getExternalRegistryClient();
            if (erc.checkConnection()) {
                String allurls = "";
                for (String u : urls) {
                    allurls = allurls + u + " ";
                }
                return "OK [connected to " + allurls + "]";
            }
            if (urls.length > 1) {
                return "ONE OR MORE REGISTRIES ARE NOT AVAILABLE";
            }
            return "CAN'T CONNECT TO REGISTRY";
        }
        catch (Exception ex) {
            return "Error! " + ex;
        }
    }
}

