/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.USEClientProperties;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.impl.InstanceChecker;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryEntryImpl;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import de.fzj.unicore.wsrflite.xmlbeans.sg.impl.ServiceGroupEntryImpl;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.MemberEPRDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryEntryUpdater
implements InstanceChecker {
    private static final Logger logger = Log.getLogger((String)"unicore.services", RegistryEntryUpdater.class);
    private final byte[] buf = new byte[1024];

    public boolean check(Home home, String id) throws ResourceUnknownException, PersistenceException {
        Calendar c = home.getTerminationTime(id);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking <" + home.getServiceName() + ">" + id + " TT = " + (c != null ? c.getTime() : "none")));
        }
        return c == null ? true : c.compareTo(Calendar.getInstance()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean process(Home home, String id) {
        GetMethod get;
        String memberAddress;
        EndpointReferenceType memberEpr;
        String serviceName;
        block16: {
            Kernel kernel;
            block15: {
                if (home.isShuttingDown()) {
                    return true;
                }
                kernel = home.getKernel();
                serviceName = home.getServiceName();
                RegistryEntryImpl entry = (RegistryEntryImpl)home.get(id);
                GetResourcePropertyDocument req = GetResourcePropertyDocument.Factory.newInstance();
                req.setGetResourceProperty(ServiceGroupEntryImpl.RPMemberEPR);
                GetResourcePropertyResponseDocument res = entry.GetResourceProperty(req);
                MemberEPRDocument memberEprDoc = MemberEPRDocument.Factory.parse((InputStream)res.getGetResourcePropertyResponse().newInputStream());
                memberEpr = memberEprDoc.getMemberEPR();
                memberAddress = memberEpr.getAddress().getStringValue();
                if (!this.checkBasicCorrectness(memberAddress, kernel)) {
                    logger.debug((Object)("Member address " + memberAddress + " is no longer valid, destroying registry entry."));
                    entry.destroy();
                    home.destroyWSRFServiceInstance(id);
                    return false;
                }
                if (RegistryEntryUpdater.wsrfResourceExists(kernel, memberAddress)) break block15;
                logger.error((Object)("Could not find WSRF instance in virtual machine. Destroying registry entry " + memberAddress));
                entry.destroy();
                home.destroyWSRFServiceInstance(id);
                return false;
            }
            String uri = WSServerUtilities.makeAddress(serviceName, kernel.getContainerProperties());
            USEClientProperties auth = kernel.getClientConfiguration();
            HttpClient client = HttpUtils.createClient((String)uri, (IClientConfiguration)auth);
            get = new GetMethod(uri + "?wsdl");
            client.executeMethod((HttpMethod)get);
            if (get.getStatusCode() == 200) break block16;
            logger.warn((Object)("Error reaching service, not publishing entry to external registry. Error was: " + get.getStatusLine().toString()));
            boolean bl = true;
            get.releaseConnection();
            return bl;
        }
        try {
            block17: {
                try {
                    InputStream is = get.getResponseBodyAsStream();
                    while (is.read(this.buf) != -1) {
                    }
                    break block17;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        get.releaseConnection();
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not reach service via web service call. Not publishing entry to external registry.", (Throwable)e);
                    return true;
                }
            }
            try {
                logger.debug((Object)("Trying to re-add service to registry: " + memberAddress));
                this.reAdd(home.getKernel(), memberEpr);
                logger.info((Object)("Refreshed registry entry for: " + memberAddress));
            }
            catch (Exception e) {
                Log.logException((String)"Error re-adding service entry: ", (Throwable)e, (Logger)logger);
            }
        }
        catch (Exception e) {
            Log.logException((String)("Could not update WSRF instance of type " + serviceName + " and id: " + id), (Throwable)e, (Logger)logger);
        }
        return true;
    }

    protected boolean checkBasicCorrectness(String url, Kernel k) {
        String baseURL = k.getContainerProperties().getValue("baseurl");
        return url != null && url.startsWith(baseURL);
    }

    protected void reAdd(Kernel kernel, EndpointReferenceType memberEpr) throws Exception {
        AddDocument add = AddDocument.Factory.newInstance();
        add.addNewAdd().setMemberEPR(memberEpr);
        add.getAdd().setInitialTerminationTime(null);
        RegistryHandler handler = (RegistryHandler)kernel.getAttribute(RegistryHandler.class);
        handler.getRegistryClient().addRegistryEntry(add);
    }

    public static boolean wsrfResourceExists(Kernel kernel, String memberAddress) {
        if (memberAddress.toLowerCase().contains("?res=")) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Alive check: " + memberAddress));
                }
                Home serviceHome = kernel.getHome(WSServerUtilities.extractServiceName((String)memberAddress));
                serviceHome.get(WSServerUtilities.extractResourceID((String)memberAddress));
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

